/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.TaskUtils;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import forge.net.mca.util.RegistryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ChoppingTask
extends AbstractChoreTask {
    private int chopTicks;
    private int targetTreeTicks;
    private BlockPos targetTree;

    public ChoppingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.CHOP && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(villager.getDominantHand());
        if (!stack.m_41619_()) {
            villager.m_21008_(villager.getDominantHand(), ItemStack.f_41583_);
        }
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_35311_(), stack -> stack.m_41720_() instanceof AxeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.chopping.noaxe");
            } else {
                villager.m_21008_(villager.getDominantHand(), villager.m_35311_().m_8020_(i));
            }
        }
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.m_35311_(), AxeItem.class) && !villager.m_21033_(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.chopping.noaxe");
        } else if (!villager.m_21033_(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_35311_(), stack -> stack.m_41720_() instanceof AxeItem);
            ItemStack stack2 = villager.m_35311_().m_8020_(i);
            villager.m_21008_(villager.getDominantHand(), stack2);
        }
        if (this.targetTree == null) {
            List<BlockPos> nearbyLogs = TaskUtils.getNearbyBlocks(villager.m_20183_(), (Level)world, blockState -> blockState.m_204336_(BlockTags.f_13106_), 15, 5);
            ArrayList<BlockPos> nearbyTrees = new ArrayList<BlockPos>();
            nearbyLogs.stream().filter(log -> this.isTreeStartLog(world, (BlockPos)log)).forEach(nearbyTrees::add);
            this.targetTree = TaskUtils.getNearestPoint(villager.m_20183_(), nearbyTrees);
            if (this.targetTree != null) {
                BlockState state;
                ItemStack stack3 = villager.m_21120_(villager.getDominantHand());
                BlockPos pos = this.targetTree;
                while ((state = world.m_8055_(pos)).m_204336_(BlockTags.f_13106_)) {
                    this.targetTreeTicks = (int)((float)this.targetTreeTicks + (float)this.getTicksFor(state, 60) / stack3.m_41691_(state));
                    pos = pos.m_7918_(0, 1, 0);
                }
            }
            this.failedTicks = 100;
            return;
        }
        villager.moveTowards(this.targetTree);
        BlockState state = world.m_8055_(this.targetTree);
        if (state.m_204336_(BlockTags.f_13106_)) {
            villager.m_6674_(villager.getDominantHand());
            ++this.chopTicks;
            if (this.chopTicks >= this.targetTreeTicks) {
                this.chopTicks = 0;
                this.destroyTree(world, this.targetTree);
            }
        } else {
            this.targetTree = null;
            this.targetTreeTicks = 0;
        }
        super.keepRunning(world, villager, time);
    }

    private boolean isTreeStartLog(ServerLevel world, BlockPos origin) {
        if (!world.m_8055_(origin).m_204336_(BlockTags.f_13106_)) {
            return false;
        }
        if (!this.isValidTree(world, origin.m_7495_())) {
            return false;
        }
        BlockPos.MutableBlockPos pos_up = origin.m_122032_();
        for (int y = 0; y < Config.getInstance().maxTreeHeight; ++y) {
            BlockState up = world.m_8055_((BlockPos)pos_up.m_142448_(pos_up.m_123342_() + 1));
            if (up.m_204336_(BlockTags.f_13106_)) continue;
            return up.m_204336_(BlockTags.f_13035_);
        }
        return false;
    }

    private void destroyTree(ServerLevel world, BlockPos origin) {
        BlockState state;
        ItemStack stack = this.villager.m_21120_(this.villager.getDominantHand());
        BlockPos pos = origin;
        while ((state = world.m_8055_(pos)).m_204336_(BlockTags.f_13106_)) {
            world.m_46953_(pos, false, (Entity)this.villager);
            pos = pos.m_7918_(0, 1, 0);
            this.villager.m_35311_().m_19173_(new ItemStack((ItemLike)state.m_60734_(), 1));
            stack.m_41622_(1, (LivingEntity)this.villager, e -> e.m_21166_(e.getDominantSlot()));
        }
    }

    private boolean isValidTree(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        ResourceLocation stateId = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        for (String blockId : Config.getInstance().validTreeSources) {
            if (blockId.equals(stateId.toString())) {
                return true;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)identifier);
            if (tag != null && !RegistryHelper.isTagEmpty(tag)) {
                if (!state.m_204336_(tag)) continue;
                return true;
            }
            throw new JsonSyntaxException("Unknown block tag in validTreeSources '" + identifier + "'");
        }
        return false;
    }

    private int getTicksFor(BlockState state, int fallback) {
        Map<String, Integer> sources = Config.getInstance().maxTreeTicks;
        ResourceLocation stateId = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        for (String blockId : sources.keySet()) {
            if (blockId.equals(stateId.toString())) {
                return sources.get(blockId);
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)identifier);
            if (tag != null && !RegistryHelper.isTagEmpty(tag)) {
                if (!state.m_204336_(tag)) continue;
                return sources.get(blockId);
            }
            throw new JsonSyntaxException("Unknown block tag in maxTreeTicks '" + identifier + "'");
        }
        return fallback;
    }
}

