/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.relationship;

import forge.net.mca.entity.ai.MoodGroup;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;

public enum Personality {
    UNASSIGNED(0, MoodGroup.UNASSIGNED),
    ATHLETIC(1, MoodGroup.PLAYFUL),
    CONFIDENT(2, MoodGroup.SERIOUS),
    STRONG(3, MoodGroup.SERIOUS),
    FRIENDLY(4, MoodGroup.GENERAL),
    TOUGH(5, MoodGroup.GENERAL),
    CURIOUS(21, MoodGroup.SERIOUS),
    PEACEFUL(22, MoodGroup.GENERAL),
    FLIRTY(23, MoodGroup.PLAYFUL),
    WITTY(24, MoodGroup.PLAYFUL),
    SHY(25, MoodGroup.GENERAL),
    GLOOMY(26, MoodGroup.GENERAL),
    SENSITIVE(41, MoodGroup.GENERAL),
    GREEDY(42, MoodGroup.SERIOUS),
    STUBBORN(43, MoodGroup.SERIOUS),
    ODD(44, MoodGroup.PLAYFUL),
    SLEEPY(45, MoodGroup.GENERAL),
    FRAGILE(46, MoodGroup.GENERAL),
    WEAK(47, MoodGroup.GENERAL),
    GRUMPY(48, MoodGroup.SERIOUS);

    private final int id;
    private final MoodGroup moodGroup;

    private Personality(int id, MoodGroup moodGroup) {
        this.id = id;
        this.moodGroup = moodGroup;
    }

    public static Personality getRandom() {
        ArrayList<Personality> validList = new ArrayList<Personality>();
        for (Personality personality : Personality.values()) {
            if (personality.id == 0) continue;
            validList.add(personality);
        }
        return (Personality)((Object)validList.get(RandomSource.m_216327_().m_188503_(validList.size())));
    }

    public int getId() {
        return this.id;
    }

    public MoodGroup getMoodGroup() {
        return this.moodGroup;
    }

    public float getDamageModifier() {
        if (this == WEAK) {
            return 0.75f;
        }
        if (this == CONFIDENT) {
            return 1.25f;
        }
        if (this == STRONG) {
            return 1.5f;
        }
        return 1.0f;
    }

    public float getWeaknessModifier() {
        if (this == TOUGH) {
            return 0.5f;
        }
        if (this == FRAGILE) {
            return 1.25f;
        }
        return 1.0f;
    }

    public float getSpeedModifier() {
        if (this == ATHLETIC) {
            return 1.15f;
        }
        if (this == SLEEPY) {
            return 0.8f;
        }
        return 1.0f;
    }

    public Component getName() {
        return Component.m_237115_((String)("personality." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    public Component getDescription() {
        return Component.m_237115_((String)("personalityDescription." + this.name().toLowerCase(Locale.ENGLISH)));
    }
}

