/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction;

import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.s2c.OpenGuiRequest;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityCommandHandler<T extends Entity> {
    @Nullable
    protected Player interactingPlayer;
    protected final T entity;

    public EntityCommandHandler(T entity) {
        this.entity = entity;
    }

    public Optional<Player> getInteractingPlayer() {
        return Optional.ofNullable(this.interactingPlayer).filter(player -> player.f_36096_ != null);
    }

    public void stopInteracting() {
        Player player;
        if (!((Entity)this.entity).f_19853_.f_46443_ && (player = this.interactingPlayer) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_6915_();
        }
        this.interactingPlayer = null;
    }

    public InteractionResult interactAt(Player player, Vec3 pos, @NotNull InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.INTERACT, (Entity)this.entity), serverPlayer);
        }
        this.interactingPlayer = player;
        return InteractionResult.SUCCESS;
    }

    public boolean handle(ServerPlayer player, String command) {
        return false;
    }
}

