/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import forge.net.mca.Config;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.GPT3;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.server.ServerInteractionManager;
import forge.net.mca.server.world.data.PlayerSaveData;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class Command {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mca").then(Command.register("help", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayHelp)))).then(Command.register("propose").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::propose)))).then(Command.register("accept").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::accept)))).then(Command.register("proposals", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::displayProposal)))).then(Command.register("procreate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::procreate)))).then(Command.register("separate", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::separate)))).then(Command.register("reject").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(Command::reject)))).then(Command.register("editor", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::editor)))).then(Command.register("destiny", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::destiny)))).then(Command.register("mail", (com.mojang.brigadier.Command<CommandSourceStack>)((com.mojang.brigadier.Command)Command::mail)))).then(Command.register("verify").then(Commands.m_82129_((String)"email", (ArgumentType)StringArgumentType.greedyString()).executes(Command::verify))));
    }

    private static int editor(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (((CommandSourceStack)ctx.getSource()).m_6761_(2) || Config.getInstance().allowFullPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.VILLAGER_EDITOR, (Entity)((CommandSourceStack)ctx.getSource()).m_230896_()), ((CommandSourceStack)ctx.getSource()).m_230896_());
            return 0;
        }
        if (Config.getInstance().allowLimitedPlayerEditor) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.LIMITED_VILLAGER_EDITOR, (Entity)((CommandSourceStack)ctx.getSource()).m_230896_()), ((CommandSourceStack)ctx.getSource()).m_230896_());
            return 0;
        }
        ((CommandSourceStack)ctx.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"command.no_permission").m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int destiny(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (((CommandSourceStack)ctx.getSource()).m_6761_(2) || Config.getInstance().allowDestinyCommandOnce) {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (!PlayerSaveData.get(player).isEntityDataSet() || Config.getInstance().allowDestinyCommandMoreThanOnce) {
                ServerInteractionManager.launchDestiny(player);
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"command.only_one_destiny").m_130940_(ChatFormatting.RED));
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"command.no_permission").m_130940_(ChatFormatting.RED));
        return 1;
    }

    private static int mail(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        PlayerSaveData data = PlayerSaveData.get(player);
        if (data.hasMail()) {
            while (data.hasMail()) {
                player.m_150109_().m_150079_(data.getMail());
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).m_230896_().m_213846_((Component)Component.m_237115_((String)"command.no_mail"));
        }
        return 0;
    }

    private static int verify(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
        CompletableFuture.runAsync(() -> {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("email", StringArgumentType.getString((CommandContext)ctx, (String)"email"));
            assert (player != null);
            params.put("player", player.m_7755_().getString());
            String encodedURL = params.keySet().stream().map(key -> key + "=" + URLEncoder.encode((String)params.get(key), StandardCharsets.UTF_8)).collect(Collectors.joining("&", Config.getInstance().villagerChatAIServer + "verify?", ""));
            GPT3.Answer request = GPT3.request(encodedURL);
            if (request.answer().equals("success")) {
                player.m_213846_((Component)Component.m_237115_((String)"command.verify.success").m_130940_(ChatFormatting.GREEN));
            } else if (request.answer().equals("failed")) {
                player.m_213846_((Component)Component.m_237115_((String)"command.verify.failed").m_130940_(ChatFormatting.RED));
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"command.verify.crashed").m_130940_(ChatFormatting.RED));
            }
        });
        return 0;
    }

    private static int displayHelp(CommandContext<CommandSourceStack> ctx) {
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "PLAYER COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca editor" + ChatFormatting.GOLD + " - Choose your genetics and stuff.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca propose <PlayerName>" + ChatFormatting.GOLD + " - Proposes marriage to the given player.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca proposals " + ChatFormatting.GOLD + " - Shows all active proposals.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca accept <PlayerName>" + ChatFormatting.GOLD + " - Accepts the player's marriage request.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca reject <PlayerName>" + ChatFormatting.GOLD + " - Rejects the player's marriage request.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca procreate " + ChatFormatting.GOLD + " - Starts procreation.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca separate " + ChatFormatting.GOLD + " - Ends your marriage.");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.DARK_RED + "--- " + ChatFormatting.GOLD + "GLOBAL COMMANDS" + ChatFormatting.DARK_RED + " ---");
        Command.sendMessage((Entity)((CommandSourceStack)ctx.getSource()).m_230896_(), ChatFormatting.WHITE + " /mca help " + ChatFormatting.GOLD + " - Shows this list of commands.");
        return 0;
    }

    private static int propose(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().sendProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static int accept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().acceptProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static int displayProposal(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().listProposals(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int procreate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().procreate(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int separate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerInteractionManager.getInstance().endMarriage(((CommandSourceStack)ctx.getSource()).m_230896_());
        return 0;
    }

    private static int reject(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"target");
        ServerInteractionManager.getInstance().rejectProposal(((CommandSourceStack)ctx.getSource()).m_230896_(), target);
        return 0;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name, com.mojang.brigadier.Command<CommandSourceStack> cmd) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0))).executes(cmd);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> register(String name) {
        return Commands.m_82127_((String)name).requires(cs -> cs.m_6761_(0));
    }

    private static void sendMessage(Entity commandSender, String message) {
        commandSender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "[MCA] " + ChatFormatting.RESET + message)));
    }
}

