/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.WorldUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;

public class GraveyardManager
extends SavedData {
    private final Map<TombstoneState, Long2ObjectMap<ChunkBase>> tombstones = new EnumMap<TombstoneState, Long2ObjectMap<ChunkBase>>(TombstoneState.class);

    public static GraveyardManager get(ServerLevel world) {
        return WorldUtils.loadData(world, GraveyardManager::new, GraveyardManager::new, "mca_graveyard");
    }

    public GraveyardManager(ServerLevel world) {
    }

    public GraveyardManager(CompoundTag nbt) {
        this.tombstones.putAll(NbtHelper.toMap(nbt, TombstoneState::valueOf, v -> {
            CompoundTag vv = (CompoundTag)v;
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            vv.m_128431_().forEach(arg_0 -> GraveyardManager.lambda$new$0((Long2ObjectMap)map, vv, arg_0));
            return map;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            this.tombstones.forEach((state, chunks) -> {
                CompoundTag chunkList = new CompoundTag();
                chunks.long2ObjectEntrySet().forEach(entry -> {
                    if (!((ChunkBase)entry.getValue()).isEmpty()) {
                        chunkList.m_128365_(String.valueOf(entry.getLongKey()), (Tag)((ChunkBase)entry.getValue()).toNbt());
                    }
                });
                if (!chunkList.m_128456_()) {
                    tag.m_128365_(state.name(), (Tag)chunkList);
                }
            });
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTombstoneState(BlockPos pos, TombstoneState state) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(state.opposite(), l, ChunkBase::empty).removePos(pos);
            this.getChunk(state, l, Chunk::new).addPos(pos);
            this.m_77762_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTombstoneState(BlockPos pos) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            long l = GraveyardManager.getChunkPos(pos);
            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).removePos(pos);
            this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).removePos(pos);
            this.m_77762_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockPos> findAll(AABB box, boolean includeEmpty, boolean includeFilled) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (includeEmpty || includeFilled) {
            int minX = Mth.m_14107_((double)((box.f_82288_ - 2.0) / 16.0));
            int maxX = Mth.m_14165_((double)((box.f_82291_ + 2.0) / 16.0));
            int minZ = Mth.m_14107_((double)((box.f_82290_ - 2.0) / 16.0));
            int maxZ = Mth.m_14165_((double)((box.f_82293_ + 2.0) / 16.0));
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
            synchronized (map) {
                for (int x = minX; x < maxX; ++x) {
                    for (int z = minZ; z < maxZ; ++z) {
                        long l = ChunkPos.m_45589_((int)x, (int)z);
                        if (includeEmpty) {
                            this.getChunk(TombstoneState.EMPTY, l, ChunkBase::empty).appendAll(box, mutable, positions);
                        }
                        if (!includeFilled) continue;
                        this.getChunk(TombstoneState.FILLED, l, ChunkBase::empty).appendAll(box, mutable, positions);
                    }
                }
            }
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<BlockPos> findNearest(BlockPos pos, TombstoneState state, int maxChunkRange) {
        Map<TombstoneState, Long2ObjectMap<ChunkBase>> map = this.tombstones;
        synchronized (map) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            return this.getChunk(state, GraveyardManager.getChunkPos(pos), ChunkBase::empty).findNearest(pos, mutable).or(() -> {
                BlockPos center = new BlockPos(SectionPos.m_123171_((int)pos.m_123341_()), 0, SectionPos.m_123171_((int)pos.m_123343_()));
                return BlockPos.m_121985_((BlockPos)center, (int)maxChunkRange, (int)0, (int)maxChunkRange).map(p -> ChunkPos.m_45589_((int)p.m_123341_(), (int)p.m_123343_())).map(l -> this.getChunk(state, (long)l, ChunkBase::empty).findNearest(pos, mutable)).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(a -> a.m_123331_((Vec3i)pos)));
            });
        }
    }

    private static long getChunkPos(BlockPos pos) {
        return ChunkPos.m_45589_((int)SectionPos.m_123171_((int)pos.m_123341_()), (int)SectionPos.m_123171_((int)pos.m_123343_()));
    }

    private ChunkBase getChunk(TombstoneState state, long pos, LongFunction<ChunkBase> fallback) {
        Long2ObjectMap chunks = this.tombstones.computeIfAbsent(state, n -> new Long2ObjectOpenHashMap());
        ChunkBase chunk = (ChunkBase)chunks.get(pos);
        if (chunk == null && (chunk = fallback.apply(pos)) != ChunkBase.EMPTY) {
            chunks.put(pos, (Object)chunk);
        }
        return chunk;
    }

    public void reportToVillageManager(Entity entity) {
        VillageManager manager = VillageManager.get((ServerLevel)entity.f_19853_);
        GraveyardManager.get((ServerLevel)entity.f_19853_).findAll(entity.m_20191_().m_82400_(24.0), true, true).stream().filter(p -> !manager.cache.contains(p)).forEach(manager::processBuilding);
    }

    private static /* synthetic */ void lambda$new$0(Long2ObjectMap map, CompoundTag vv, String key) {
        map.put(Long.parseLong(key), (Object)new Chunk((ListTag)vv.m_128423_(key)));
    }

    public static enum TombstoneState {
        EMPTY,
        FILLED;


        TombstoneState opposite() {
            return this == EMPTY ? FILLED : EMPTY;
        }
    }

    private static class ChunkBase {
        static final ChunkBase EMPTY = new ChunkBase();

        private ChunkBase() {
        }

        static ChunkBase empty(long l) {
            return EMPTY;
        }

        public boolean isEmpty() {
            return true;
        }

        public ListTag toNbt() {
            return new ListTag();
        }

        public void removePos(BlockPos pos) {
        }

        public void addPos(BlockPos pos) {
        }

        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.MutableBlockPos mutable) {
            return Optional.empty();
        }

        public void appendAll(AABB box, BlockPos.MutableBlockPos mutable, List<BlockPos> positions) {
        }
    }

    private static class Chunk
    extends ChunkBase {
        private final LongSet tombstones = new LongArraySet();

        Chunk(long l) {
        }

        Chunk(ListTag list) {
            list.forEach(l -> this.tombstones.add(((NumericTag)l).m_7046_()));
        }

        @Override
        public boolean isEmpty() {
            return this.tombstones.isEmpty();
        }

        @Override
        public ListTag toNbt() {
            ListTag list = new ListTag();
            this.tombstones.forEach(l -> list.add((Object)LongTag.m_128882_((long)l)));
            return list;
        }

        @Override
        public void removePos(BlockPos pos) {
            this.tombstones.remove(pos.m_121878_());
        }

        @Override
        public void addPos(BlockPos pos) {
            this.tombstones.add(pos.m_121878_());
        }

        @Override
        public Optional<BlockPos> findNearest(BlockPos pos, BlockPos.MutableBlockPos mutable) {
            double distance = Double.MAX_VALUE;
            long nearest = -1L;
            boolean found = false;
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.m_122188_(l);
                double d = pos.m_123331_((Vec3i)mutable);
                if (!(d < distance)) continue;
                distance = d;
                nearest = l;
                found = true;
            }
            return found ? Optional.of(BlockPos.m_122022_((long)nearest)) : Optional.empty();
        }

        @Override
        public void appendAll(AABB box, BlockPos.MutableBlockPos mutable, List<BlockPos> positions) {
            LongIterator longIterator = this.tombstones.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                mutable.m_122188_(l);
                if (!box.m_82393_((double)mutable.m_123341_(), (double)mutable.m_123342_(), (double)mutable.m_123343_())) continue;
                positions.add(mutable.m_7949_());
            }
        }
    }
}

