/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.mixin;

import java.text.Normalizer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2797;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import quilt.net.mca.Config;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.GPT3;
import quilt.net.mca.util.WorldUtils;

@Mixin(value={class_3244.class})
public class MixinServerPlayNetworkHandler {
    @Shadow
    public class_3222 field_14140;

    private String normalize(String string) {
        return Normalizer.normalize(string, Normalizer.Form.NFD).replaceAll("\\p{M}", "").toLowerCase(Locale.ROOT);
    }

    @Inject(method={"onChatMessage"}, at={@At(value="HEAD")})
    public void sendMessage(class_2797 message, CallbackInfo ci) {
        String msg;
        if (Config.getInstance().enableVillagerChatAI && !(msg = StringUtils.normalizeSpace((String)message.comp_945())).startsWith("/")) {
            List<VillagerEntityMCA> entities = WorldUtils.getCloseEntities(this.field_14140.field_6002, (class_1297)this.field_14140, 32.0, VillagerEntityMCA.class);
            String search = this.normalize(msg);
            boolean talked = false;
            for (VillagerEntityMCA villager : entities) {
                String name = this.normalize((String)villager.getTrackedValue(VillagerLike.VILLAGER_NAME));
                if (!search.contains(name)) continue;
                CompletableFuture.runAsync(() -> GPT3.answer(this.field_14140, villager, msg).ifPresent(a -> villager.conversationManager.addMessage((class_1297)this.field_14140, class_2561.method_43470((String)a))));
                talked = true;
                break;
            }
            if (!talked) {
                for (VillagerEntityMCA villager : entities) {
                    if (!GPT3.inConversationWith(villager, this.field_14140)) continue;
                    CompletableFuture.runAsync(() -> GPT3.answer(this.field_14140, villager, msg).ifPresent(a -> villager.conversationManager.addMessage((class_1297)this.field_14140, class_2561.method_43470((String)a))));
                    break;
                }
            }
        }
    }
}

