/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.forge.quark;

import com.google.common.base.Stopwatch;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapsHandler;
import net.mehvahdjukaar.supplementaries.integration.forge.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import org.jetbrains.annotations.Nullable;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.tools.item.PathfindersQuillItem;
import vazkii.quark.content.tools.module.PathfinderMapsModule;

public class CartographersQuillItem
extends PathfindersQuillItem {
    public static final String TAG_STRUCTURE = "targetStructure";
    public static final String TAG_SKIP_KNOWN = "skinKnown";
    public static final String TAG_SEARCH_RADIUS = "maxSearchRadius";
    public static final String TAG_ZOOM = "zoomLevel";
    public static final String TAG_DECORATION = "decoration";
    public static final String TAG_NAME = "decoration";
    protected static final String TAG_RADIUS = "searchRadius";
    protected static final String TAG_POS_INDEX = "searchIndex";
    protected static final String TAG_WAITING = "waiting";
    private static Thread mainThread;
    private static final Map<Key, InteractionResultHolder<BlockPos>> RESULTS;
    private static final Set<Key> COMPUTING;
    private static final Set<ChunkPos> COMPUTING_CHUNKPOS;

    public CartographersQuillItem() {
        super(ModuleLoader.INSTANCE.getModuleInstance(PathfinderMapsModule.class), new Item.Properties().m_41487_(1).m_41491_(RegUtils.getTab(CreativeModeTab.f_40756_, "adventurer_map")));
        QuarkCompatImpl.removeStuffFromARLHack();
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> comps, TooltipFlag flags) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"isSearchingForBiome", (boolean)false)) {
                comps.add((Component)CartographersQuillItem.getSearchingComponent().m_130940_(ChatFormatting.BLUE));
            }
        } else {
            comps.add((Component)Component.m_237115_((String)"message.supplementaries.cartographers_quill").m_130940_(ChatFormatting.GRAY));
        }
    }

    protected String getFailedMessage() {
        return "message.supplementaries.quill_failed";
    }

    protected String getFinishedMessage() {
        return "message.supplementaries.quill_finished";
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.f_41377_ != null && (group == this.f_41377_ || group == CreativeModeTab.f_40754_)) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public int getIterations() {
        return 500;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            String str;
            ServerLevel serverLevel = (ServerLevel)level;
            CompoundTag tag = player.m_21120_(hand).m_41784_();
            if (!tag.m_128441_(TAG_STRUCTURE) && (str = CartographersQuillItem.selectRandomTarget(serverLevel, ModTags.ADVENTURE_MAP_DESTINATIONS)) != null) {
                tag.m_128359_(TAG_STRUCTURE, str);
            }
        }
        return super.m_7203_(level, player, hand);
    }

    @Nullable
    public ResourceLocation getTarget(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String str = tag.m_128461_(TAG_STRUCTURE);
        return new ResourceLocation(str);
    }

    @Nullable
    private Holder<Structure> getStructureHolder(ServerLevel level, ResourceLocation key) {
        Registry reg = level.m_5962_().m_175515_(Registry.f_235725_);
        Optional structure = reg.m_203636_(ResourceKey.m_135785_((ResourceKey)reg.m_123023_(), (ResourceLocation)key));
        return structure.orElse(null);
    }

    public ItemStack createMap(ServerLevel level, BlockPos targetPos, ResourceLocation structure, ItemStack original) {
        CompoundTag tag = original.m_41784_();
        return AdventurerMapsHandler.createStructureMap(level, targetPos, this.getStructureHolder(level, structure), this.getZoomLevel(tag), this.getDecoration(tag), this.getMapName(tag), this.getColor(tag));
    }

    protected InteractionResultHolder<BlockPos> searchConcurrent(ResourceLocation target, ItemStack stack, ServerLevel level, Player player) {
        CompoundTag tag = stack.m_41784_();
        Holder<Structure> structure = this.getStructureHolder(level, target);
        State state = State.get(tag);
        if (structure == null || state == null) {
            return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
        }
        BlockPos center = this.getOrCreateStartPos(tag, player);
        int radius = this.getSearchRadius(tag);
        boolean skipKnown = this.getSkipKnown(tag);
        Key key = new Key(GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)center), ((ResourceKey)structure.m_203543_().get()).m_135782_(), radius, skipKnown);
        if (COMPUTING.contains(key)) {
            return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
        }
        if (RESULTS.containsKey(key)) {
            InteractionResultHolder<BlockPos> ret = RESULTS.remove(key);
            if (ret.m_19089_() == InteractionResult.PASS) {
                return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
            }
            return ret;
        }
        ItemStack dummy = stack.m_41777_();
        EXECUTORS.submit(() -> {
            COMPUTING.add(key);
            RESULTS.put(key, this.searchIterative(target, dummy, level, player, Integer.MAX_VALUE));
            COMPUTING.remove(key);
        });
        return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
    }

    protected InteractionResultHolder<BlockPos> searchIterative(ResourceLocation target, ItemStack stack, ServerLevel level, Player player, int maxIter) {
        CompoundTag tag = stack.m_41784_();
        Holder<Structure> structure = this.getStructureHolder(level, target);
        State state = State.get(tag);
        if (structure == null || state == null) {
            return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
        }
        BlockPos center = this.getOrCreateStartPos(tag, player);
        int radius = this.getSearchRadius(tag);
        boolean skipKnown = this.getSkipKnown(tag);
        return this.findNearestMapStructure(level, structure, radius, center, skipKnown, state, maxIter);
    }

    protected ItemStack search(ItemStack stack, ServerLevel level, Player player, int slot) {
        if (mainThread == null) {
            mainThread = Thread.currentThread();
        }
        return super.search(stack, level, player, slot);
    }

    private BlockPos getOrCreateStartPos(CompoundTag tag, Player player) {
        if (tag.m_128441_("searchSourceX") && tag.m_128441_("searchSourceZ")) {
            int sourceX = tag.m_128451_("searchSourceX");
            int sourceZ = tag.m_128451_("searchSourceZ");
            return new BlockPos(sourceX, 64, sourceZ);
        }
        BlockPos pos = player.m_20183_();
        tag.m_128405_("searchSourceX", pos.m_123341_());
        tag.m_128405_("searchSourceZ", pos.m_123343_());
        return pos;
    }

    private int getSearchRadius(CompoundTag tag) {
        if (tag.m_128441_(TAG_SEARCH_RADIUS)) {
            return tag.m_128451_(TAG_SEARCH_RADIUS);
        }
        return 150;
    }

    @Nullable
    private String getMapName(CompoundTag tag) {
        if (tag.m_128441_("decoration")) {
            return tag.m_128461_("decoration");
        }
        return null;
    }

    private int getColor(CompoundTag tag) {
        if (tag.m_128441_("targetBiomeColor")) {
            return tag.m_128451_("targetBiomeColor");
        }
        return 0;
    }

    @Nullable
    private ResourceLocation getDecoration(CompoundTag tag) {
        if (tag.m_128441_("decoration")) {
            return new ResourceLocation(tag.m_128461_("decoration"));
        }
        return null;
    }

    private int getZoomLevel(CompoundTag tag) {
        if (tag.m_128441_(TAG_ZOOM)) {
            return tag.m_128451_(TAG_ZOOM);
        }
        return 2;
    }

    private boolean getSkipKnown(CompoundTag tag) {
        if (tag.m_128441_(TAG_SKIP_KNOWN)) {
            return tag.m_128471_(TAG_SKIP_KNOWN);
        }
        return true;
    }

    @Nullable
    public InteractionResultHolder<BlockPos> findNearestMapStructure(ServerLevel level, Holder<Structure> holder, int searchRadius, BlockPos center, boolean skipKnownStructures, State state, int maxIterations) {
        if (!level.m_7654_().m_129910_().m_5961_().m_224677_()) {
            return null;
        }
        ServerChunkCache source = level.m_7726_();
        ChunkGenerator gen = source.m_8481_();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (StructurePlacement structurePlacement : gen.m_223138_(holder, source.m_214994_())) {
            map.computeIfAbsent(structurePlacement, ss -> new ObjectArraySet()).add(holder);
        }
        if (map.isEmpty()) {
            return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
        }
        double d = Double.MAX_VALUE;
        StructureManager structureManager = level.m_215010_();
        ArrayList<Pair> list = new ArrayList<Pair>(map.size());
        for (Map.Entry ent : map.entrySet()) {
            StructurePlacement placement = (StructurePlacement)ent.getKey();
            if (placement instanceof ConcentricRingsStructurePlacement) {
                BlockPos blockPos;
                double e;
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)placement;
                Pair pair2 = gen.m_223181_((Set)ent.getValue(), level, structureManager, center, skipKnownStructures, concentricRingsStructurePlacement);
                if (pair2 == null || !((e = center.m_123331_((Vec3i)(blockPos = (BlockPos)pair2.getFirst()))) < d)) continue;
                return InteractionResultHolder.m_19090_((Object)((BlockPos)pair2.getFirst()));
            }
            if (!(placement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement rr = (RandomSpreadStructurePlacement)placement;
            list.add(Pair.of((Object)rr, (Object)((Set)ent.getValue())));
        }
        if (list.isEmpty()) {
            return null;
        }
        int centerX = SectionPos.m_123171_((int)center.m_123341_());
        int centerY = SectionPos.m_123171_((int)center.m_123343_());
        long seed = level.m_7328_();
        int currentIter = 0;
        while (state.radius <= searchRadius) {
            BlockPos found = null;
            while (state.placementInd < list.size()) {
                double f;
                Pair pl = (Pair)list.get(state.placementInd);
                RandomSpreadStructurePlacement placement = (RandomSpreadStructurePlacement)pl.getFirst();
                Set holderSet = (Set)pl.getSecond();
                BlockPos foundPair = null;
                int spacing = placement.m_205003_();
                block4: while (state.x <= state.radius) {
                    boolean onEdgeX;
                    boolean bl = onEdgeX = state.x == -state.radius || state.x == state.radius;
                    while (state.z <= state.radius) {
                        boolean onEdgeY;
                        boolean bl2 = onEdgeY = state.z == -state.radius || state.z == state.radius;
                        if (onEdgeX || onEdgeY) {
                            ++currentIter;
                            int testX = centerX + spacing * state.x;
                            int testY = centerY + spacing * state.z;
                            ChunkPos chunkPos = placement.m_227008_(seed, testX, testY);
                            Either<BlockPos, ChunkPos> pair = CartographersQuillItem.getStructureGeneratingAt(holderSet, source, structureManager, skipKnownStructures, (StructurePlacement)placement, chunkPos, state);
                            if (pair != null) {
                                Optional left = pair.left();
                                if (left.isPresent()) {
                                    foundPair = (BlockPos)left.get();
                                    state.z = -state.radius;
                                    break block4;
                                }
                                return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
                            }
                            if (currentIter > maxIterations) {
                                return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
                            }
                        }
                        ++state.z;
                    }
                    state.z = -state.radius;
                    ++state.x;
                }
                state.x = -state.radius;
                if (foundPair != null && (f = center.m_123331_(foundPair)) < d) {
                    d = f;
                    found = foundPair;
                }
                ++state.placementInd;
            }
            state.placementInd = 0;
            if (found != null) {
                return InteractionResultHolder.m_19090_(found);
            }
            ++state.radius;
        }
        return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
    }

    public static Either<BlockPos, ChunkPos> getStructureGeneratingAt(Set<Holder<Structure>> structureHoldersSet, ServerChunkCache chunkCache, StructureManager structureManager, boolean skipKnownStructures, StructurePlacement placement, ChunkPos chunkPos, State state) {
        Stopwatch s2 = Stopwatch.createStarted();
        for (Holder<Structure> holder : structureHoldersSet) {
            Structure structure = (Structure)holder.m_203334_();
            StructureCheckResult structureCheckResult = structureManager.m_220473_(chunkPos, structure, skipKnownStructures);
            if (structureCheckResult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!skipKnownStructures && structureCheckResult == StructureCheckResult.START_PRESENT) {
                return Either.left((Object)placement.m_227039_(chunkPos));
            }
            boolean shouldMultiThread = Thread.currentThread() == mainThread;
            ChunkAccess chunkAccess = chunkCache.m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_, !shouldMultiThread);
            if (chunkAccess == null && shouldMultiThread) {
                if (state.waiting && !COMPUTING_CHUNKPOS.contains(chunkPos)) {
                    state.waiting = false;
                }
                if (!state.waiting) {
                    EXECUTORS.submit(() -> {
                        COMPUTING_CHUNKPOS.add(chunkPos);
                        chunkCache.m_7587_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_, true);
                        COMPUTING_CHUNKPOS.remove(chunkPos);
                    });
                    state.waiting = true;
                }
                if (state.z == -state.radius) {
                    ++state.z;
                    if (state.x == -state.radius) {
                        ++state.x;
                        --state.radius;
                    } else {
                        --state.x;
                    }
                } else {
                    --state.z;
                }
                Supplementaries.LOGGER.warn("E " + s2.elapsed());
                return Either.right((Object)chunkPos);
            }
            state.waiting = false;
            StructureStart structureStart = structureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)chunkAccess), structure, (StructureAccess)chunkAccess);
            if (structureStart == null || !structureStart.m_73603_() || skipKnownStructures && !CartographersQuillItem.tryAddReference(structureManager, structureStart)) continue;
            return Either.left((Object)placement.m_227039_(structureStart.m_163625_()));
        }
        return null;
    }

    private static boolean tryAddReference(StructureManager structureManager, StructureStart structureStrart) {
        if (structureStrart.m_73606_()) {
            structureManager.m_220484_(structureStrart);
            return true;
        }
        return false;
    }

    public static ItemStack forStructure(ServerLevel level, @Nullable TagKey<Structure> tag, int searchRadius, boolean skipKnown, int zoom, @Nullable MapDecoration.Type deco, @Nullable String name, int color) {
        ItemStack stack = CartographersQuillItem.forStructure(level, tag);
        CompoundTag t = stack.m_41784_();
        t.m_128405_(TAG_SEARCH_RADIUS, searchRadius);
        t.m_128379_(TAG_SKIP_KNOWN, skipKnown);
        t.m_128405_(TAG_ZOOM, zoom);
        if (deco != null) {
            t.m_128359_("decoration", deco.toString().toLowerCase(Locale.ROOT));
        }
        if (name != null) {
            t.m_128359_("decoration", name);
        }
        if (color != 0) {
            t.m_128405_("targetBiomeColor", color);
        }
        return stack;
    }

    public static int getItemColor(ItemStack stack, int layer) {
        if (layer == 0) {
            return -1;
        }
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("targetBiomeColor")) {
            int i = compoundTag.m_128451_("targetBiomeColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return 0;
    }

    public static ItemStack forStructure(ServerLevel level, @Nullable TagKey<Structure> tag) {
        ItemStack stack = QuarkCompatImpl.CARTOGRAPHERS_QUILL.get().m_7968_();
        if (tag != null) {
            String target = CartographersQuillItem.selectRandomTarget(level, tag);
            if (target == null) {
                return ItemStack.f_41583_;
            }
            stack.m_41784_().m_128359_(TAG_STRUCTURE, target);
        }
        return stack;
    }

    @Nullable
    private static String selectRandomTarget(ServerLevel level, TagKey<Structure> tag) {
        Optional taggedStructures = level.m_5962_().m_175515_(Registry.f_235725_).m_203431_(tag);
        if (taggedStructures.isPresent()) {
            ArrayList<Holder> reachable = new ArrayList<Holder>();
            ServerChunkCache source = level.m_7726_();
            ChunkGenerator chunkGenerator = source.m_8481_();
            for (Holder s : (HolderSet.Named)taggedStructures.get()) {
                if (chunkGenerator.m_223138_(s, source.m_214994_()).isEmpty()) continue;
                reachable.add(s);
            }
            if (!reachable.isEmpty()) {
                Holder selected = (Holder)reachable.get(level.f_46441_.m_188503_(reachable.size()));
                return ((ResourceKey)selected.m_203543_().get()).m_135782_().toString();
            }
        }
        return null;
    }

    static {
        RESULTS = new ConcurrentHashMap<Key, InteractionResultHolder<BlockPos>>();
        COMPUTING = ConcurrentHashMap.newKeySet();
        COMPUTING_CHUNKPOS = ConcurrentHashMap.newKeySet();
    }

    private static final class State {
        private boolean waiting;
        private int radius;
        private int x;
        private int z;
        private int placementInd;

        private State(int lastRadius, int lastX, int lastZ, int index, boolean waiting) {
            this.radius = lastRadius;
            this.x = lastX;
            this.z = lastZ;
            this.placementInd = index;
            this.waiting = waiting;
        }

        public void save(CompoundTag tag) {
            tag.m_128405_(CartographersQuillItem.TAG_RADIUS, this.radius);
            tag.m_128405_("searchPosX", this.x);
            tag.m_128405_("searchPosZ", this.z);
            tag.m_128405_(CartographersQuillItem.TAG_POS_INDEX, this.placementInd);
            tag.m_128379_(CartographersQuillItem.TAG_WAITING, this.waiting);
        }

        @Nullable
        private static State get(CompoundTag tag) {
            int radius = 0;
            if (tag.m_128441_(CartographersQuillItem.TAG_RADIUS)) {
                radius = tag.m_128451_(CartographersQuillItem.TAG_RADIUS);
            }
            int x = 0;
            if (tag.m_128441_("searchPosX")) {
                x = tag.m_128451_("searchPosX");
            }
            int z = 0;
            if (tag.m_128441_("searchPosZ")) {
                z = tag.m_128451_("searchPosZ");
            }
            int index = 0;
            if (tag.m_128441_(CartographersQuillItem.TAG_POS_INDEX)) {
                index = tag.m_128451_(CartographersQuillItem.TAG_POS_INDEX);
            }
            boolean waiting = false;
            if (tag.m_128441_(CartographersQuillItem.TAG_WAITING)) {
                waiting = tag.m_128471_(CartographersQuillItem.TAG_WAITING);
            }
            if (x > radius || z > radius) {
                return null;
            }
            return new State(radius, x, z, index, waiting);
        }
    }

    private record Key(GlobalPos pos, ResourceLocation structure, int radius, boolean bool) {
    }
}

