/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MemoryReserve;
import net.minecraft.world.entity.Entity;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.packet.EntityIDSyncPacket;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.searchtree.JEIBackedSearchTree;
import org.embeddedt.modernfix.searchtree.REIBackedSearchTree;
import org.embeddedt.modernfix.searchtree.SearchTreeProviderRegistry;
import org.embeddedt.modernfix.world.IntegratedWatchdog;

public class ModernFixClient {
    public static long worldLoadStartTime;
    private static int numRenderTicks;
    public static float gameStartTimeSeconds;
    private static boolean recipesUpdated;
    private static boolean tagsUpdated;
    public String brandingString = null;
    public static List<ModernFixClientIntegration> CLIENT_INTEGRATIONS;
    public static final Set<SynchedEntityData> allEntityDatas;
    private static final Field entriesArrayField;

    public ModernFixClient() {
        MemoryReserve.m_182328_();
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.branding.F3Screen")) {
            this.brandingString = ModernFix.NAME + " " + ModernFixPlatformHooks.getVersionString();
        }
        SearchTreeProviderRegistry.register(JEIBackedSearchTree.PROVIDER);
        SearchTreeProviderRegistry.register(REIBackedSearchTree.PROVIDER);
        for (String className : ModernFixPlatformHooks.getCustomModOptions().get((Object)"client_entrypoint")) {
            try {
                CLIENT_INTEGRATIONS.add((ModernFixClientIntegration)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Could not instantiate integration {}", (Object)className, (Object)e);
            }
        }
    }

    public void resetWorldLoadStateMachine() {
        numRenderTicks = 0;
        worldLoadStartTime = -1L;
        recipesUpdated = false;
        tagsUpdated = false;
    }

    public void onScreenOpening(Screen openingScreen) {
        if (openingScreen instanceof ConnectScreen) {
            worldLoadStartTime = System.nanoTime();
        } else if (openingScreen instanceof TitleScreen && gameStartTimeSeconds < 0.0f) {
            gameStartTimeSeconds = (float)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0f;
            ModernFix.LOGGER.warn("Game took " + gameStartTimeSeconds + " seconds to start");
        }
    }

    public void onRecipesUpdated() {
        recipesUpdated = true;
    }

    public void onTagsUpdated() {
        tagsUpdated = true;
    }

    public void onRenderTickEnd() {
        if (recipesUpdated && tagsUpdated && worldLoadStartTime != -1L && Minecraft.m_91087_().f_91074_ != null && numRenderTicks++ >= 10) {
            float timeSpentLoading = (float)(System.nanoTime() - worldLoadStartTime) / 1.0E9f;
            ModernFix.LOGGER.warn("Time from main menu to in-game was " + timeSpentLoading + " seconds");
            ModernFix.LOGGER.warn("Total time to load game and open world was " + (timeSpentLoading + gameStartTimeSeconds) + " seconds");
            this.resetWorldLoadStateMachine();
        }
    }

    private static boolean compareAndSwitchIds(Class<? extends Entity> eClass, String fieldName, EntityDataAccessor<?> accessor, int newId) {
        if (accessor.f_135010_ != newId) {
            ModernFix.LOGGER.warn("Corrected ID mismatch on {} field {}. Client had {} but server wants {}.", eClass, (Object)fieldName, (Object)accessor.f_135010_, (Object)newId);
            accessor.f_135010_ = newId;
            return true;
        }
        ModernFix.LOGGER.debug("{} {} ID fine: {}", eClass, (Object)fieldName, (Object)newId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleEntityIDSync(EntityIDSyncPacket packet) {
        Map<Class<? extends Entity>, List<Pair<String, Integer>>> info = packet.getFieldInfo();
        boolean fixNeeded = false;
        for (Map.Entry<Class<? extends Entity>, List<Pair<String, Integer>>> entry : info.entrySet()) {
            Class<? extends Entity> eClass = entry.getKey();
            for (Pair<String, Integer> field : entry.getValue()) {
                String fieldName = (String)field.getFirst();
                int newId = (Integer)field.getSecond();
                try {
                    Field f = eClass.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    EntityDataAccessor accessor = (EntityDataAccessor)f.get(null);
                    if (!ModernFixClient.compareAndSwitchIds(eClass, fieldName, accessor, newId)) continue;
                    fixNeeded = true;
                }
                catch (NoSuchFieldException e) {
                    ModernFix.LOGGER.warn("Couldn't find field on {}: {}", eClass, (Object)fieldName);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Unexpected exception", e);
                }
            }
        }
        Set<SynchedEntityData> set = allEntityDatas;
        synchronized (set) {
            if (fixNeeded) {
                ArrayList<SynchedEntityData> dataEntries = new ArrayList<SynchedEntityData>(allEntityDatas);
                for (SynchedEntityData manager : dataEntries) {
                    Int2ObjectOpenHashMap fixedMap = new Int2ObjectOpenHashMap();
                    ArrayList items = new ArrayList(manager.f_135345_.values());
                    for (SynchedEntityData.DataItem item : items) {
                        fixedMap.put(item.m_135396_().f_135010_, (Object)item);
                    }
                    manager.f_135346_.writeLock().lock();
                    try {
                        manager.f_135345_.replaceAll((id, parameter) -> (SynchedEntityData.DataItem)fixedMap.get(id.intValue()));
                        if (entriesArrayField == null) continue;
                        try {
                            SynchedEntityData.DataItem[] dataArray = new SynchedEntityData.DataItem[items.size()];
                            for (int i = 0; i < dataArray.length; ++i) {
                                dataArray[i] = (SynchedEntityData.DataItem)fixedMap.get(i);
                            }
                            entriesArrayField.set(manager, dataArray);
                        }
                        catch (ReflectiveOperationException e) {
                            ModernFix.LOGGER.error((Object)e);
                        }
                    }
                    finally {
                        manager.f_135346_.writeLock().unlock();
                    }
                }
            }
            allEntityDatas.clear();
        }
    }

    public void onServerStarted(MinecraftServer server) {
        if (!ModernFixMixinPlugin.instance.isOptionEnabled("feature.integrated_server_watchdog.IntegratedWatchdog")) {
            return;
        }
        IntegratedWatchdog watchdog = new IntegratedWatchdog(server);
        watchdog.start();
    }

    static {
        Field field;
        gameStartTimeSeconds = -1.0f;
        tagsUpdated = false;
        CLIENT_INTEGRATIONS = new CopyOnWriteArrayList<ModernFixClientIntegration>();
        allEntityDatas = Collections.newSetFromMap(new WeakHashMap());
        try {
            field = SynchedEntityData.class.getDeclaredField("entriesArray");
            field.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            field = null;
        }
        entriesArrayField = field;
    }
}

