/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.core;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.modernfix.core.config.ModernFixEarlyConfig;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ModernFixMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "org.embeddedt.modernfix.mixin.";
    public final Logger logger = LogManager.getLogger((String)"ModernFix");
    public ModernFixEarlyConfig config = null;
    public static ModernFixMixinPlugin instance;

    public ModernFixMixinPlugin() {
        boolean firstConfig;
        ModernFixPlatformHooks.getCustomModOptions();
        boolean bl = firstConfig = instance == null;
        if (firstConfig) {
            instance = this;
            try {
                this.config = ModernFixEarlyConfig.load(new File("./config/modernfix-mixins.properties"));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load configuration file for ModernFix", e);
            }
            this.logger.info("Loaded configuration file for ModernFix: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
            if (ModernFixEarlyConfig.OPTIFINE_PRESENT) {
                this.logger.fatal("OptiFine detected. Use of ModernFix with OptiFine is not supported due to its impact on launch time and breakage of Forge features.");
            }
            try {
                Class.forName("sun.misc.Unsafe").getDeclaredMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
            }
            catch (NullPointerException | ReflectiveOperationException e) {
                this.logger.info("Applying Nashorn fix");
                Properties properties = System.getProperties();
                properties.setProperty("nashorn.args", properties.getProperty("nashorn.args", "") + " --anonymous-classes=false");
            }
            ModernFixPlatformHooks.injectPlatformSpecificHacks();
        }
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!(mixinClassName = ModernFixEarlyConfig.sanitize(mixinClassName)).startsWith(MIXIN_PACKAGE_ROOT)) {
            this.logger.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        String mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length());
        if (!instance.isOptionEnabled(mixin)) {
            return false;
        }
        String disabledBecauseMod = ModernFixMixinPlugin.instance.config.getPermanentlyDisabledMixins().get(mixin);
        return disabledBecauseMod == null;
    }

    public boolean isOptionEnabled(String mixin) {
        Option option = ModernFixMixinPlugin.instance.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            return false;
        }
        if (option.isOverridden()) {
            Object source = "[unknown]";
            if (option.isUserDefined()) {
                source = "user configuration";
            } else if (option.isModDefined()) {
                source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
            }
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getName(), source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getName(), source);
            }
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        ModernFixPlatformHooks.applyASMTransformers(mixinClassName, targetClass);
    }
}

