/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;

public class OptionList
extends ContainerObjectSelectionList<Entry> {
    private final int maxNameWidth;
    private static final Component OPTION_ON = Component.m_237115_((String)"modernfix.option.on").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN));
    private static final Component OPTION_OFF = Component.m_237115_((String)"modernfix.option.off").m_130938_(style -> style.m_131140_(ChatFormatting.RED));
    private ModernFixConfigScreen mainScreen;

    public OptionList(ModernFixConfigScreen arg, Minecraft arg2) {
        super(arg2, arg.f_96543_ + 45, arg.f_96544_, 43, arg.f_96544_ - 32, 20);
        this.mainScreen = arg;
        int maxW = 0;
        Map<String, Option> optionMap = ModernFixMixinPlugin.instance.config.getOptionMap();
        List sortedKeys = optionMap.keySet().stream().filter(key -> !key.equals("mixin.core")).sorted().collect(Collectors.toList());
        for (String key2 : sortedKeys) {
            Option option = optionMap.get(key2);
            int w = this.f_93386_.f_91062_.m_92895_(key2);
            maxW = Math.max(w, maxW);
            this.m_7085_((AbstractSelectionList.Entry)new OptionEntry(key2, option));
        }
        this.maxNameWidth = maxW;
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    class OptionEntry
    extends Entry {
        private final String name;
        private final Button toggleButton;
        private final Option option;

        public OptionEntry(String optionName, Option option) {
            this.name = optionName;
            this.option = option;
            this.toggleButton = new Button(0, 0, 95, 20, (Component)Component.m_237113_((String)""), arg -> {
                this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                try {
                    ModernFixMixinPlugin.instance.config.save();
                    if (!OptionList.this.mainScreen.madeChanges) {
                        OptionList.this.mainScreen.madeChanges = true;
                    }
                }
                catch (IOException e) {
                    this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                    ModernFix.LOGGER.error("Unable to save config", (Throwable)e);
                }
            });
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            MutableComponent nameComponent = Component.m_237113_((String)this.name);
            if (this.option.isUserDefined()) {
                nameComponent = nameComponent.m_130940_(ChatFormatting.ITALIC).m_7220_((Component)Component.m_237115_((String)"modernfix.config.not_default"));
            }
            ((OptionList)OptionList.this).f_93386_.f_91062_.m_92889_(matrixStack, (Component)nameComponent, (float)(left + 160 - OptionList.this.maxNameWidth), (float)(top + height / 2 - 4), 0xFFFFFF);
            this.toggleButton.f_93620_ = left + 175;
            this.toggleButton.f_93621_ = top;
            this.toggleButton.m_93666_(this.getOptionMessage(this.option));
            this.toggleButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }

        private Component getOptionMessage(Option option) {
            return option.isEnabled() ? OPTION_ON : OPTION_OFF;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.toggleButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.toggleButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.toggleButton.m_6348_(mouseX, mouseY, button);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

