/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import com.google.common.base.Predicates;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.impl.client.search.AsyncSearchManager;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.client.searchtree.RefreshableSearchTree;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.searchtree.DummySearchTree;
import org.embeddedt.modernfix.searchtree.SearchTreeProviderRegistry;

public class REIBackedSearchTree
extends DummySearchTree<ItemStack> {
    private final AsyncSearchManager searchManager = REIBackedSearchTree.createSearchManager();
    private final boolean filteringByTag;
    private String lastSearchText = "";
    private final List<ItemStack> listCache = new ArrayList<ItemStack>();
    public static final SearchTreeProviderRegistry.Provider PROVIDER = new SearchTreeProviderRegistry.Provider(){

        @Override
        public RefreshableSearchTree<ItemStack> getSearchTree(boolean tag) {
            return new REIBackedSearchTree(tag);
        }

        @Override
        public boolean canUse() {
            return ModernFixPlatformHooks.modPresent("roughlyenoughitems");
        }

        @Override
        public String getName() {
            return "REI";
        }
    };

    public REIBackedSearchTree(boolean filteringByTag) {
        this.filteringByTag = filteringByTag;
    }

    @Override
    public List<ItemStack> m_6293_(String pSearchText) {
        return this.searchREI(pSearchText);
    }

    private List<ItemStack> searchREI(String pSearchText) {
        if (!pSearchText.equals(this.lastSearchText)) {
            List stacks;
            this.listCache.clear();
            this.searchManager.updateFilter(pSearchText);
            try {
                stacks = this.searchManager.getNow();
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Couldn't search for '" + pSearchText + "'", (Throwable)e);
                stacks = Collections.emptyList();
            }
            for (Object o : stacks) {
                EntryStack stack;
                if (o instanceof EntryStack) {
                    stack = (EntryStack)o;
                } else if (o instanceof HashedEntryStackWrapper) {
                    stack = ((HashedEntryStackWrapper)o).unwrap();
                } else {
                    ModernFix.LOGGER.error("Don't know how to handle {}", (Object)o.getClass().getName());
                    continue;
                }
                if (stack.getType() != VanillaEntryTypes.ITEM) continue;
                this.listCache.add((ItemStack)stack.cheatsAs().getValue());
            }
            this.lastSearchText = pSearchText;
        }
        return this.listCache;
    }

    private static AsyncSearchManager createSearchManager() {
        try {
            Method normalizeMethod;
            Method m;
            try {
                m = EntryRegistryImpl.class.getDeclaredMethod("getPreFilteredComplexList", new Class[0]);
                m.setAccessible(true);
                normalizeMethod = HashedEntryStackWrapper.class.getDeclaredMethod("normalize", new Class[0]);
                normalizeMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                m = EntryRegistryImpl.class.getDeclaredMethod("getPreFilteredList", new Class[0]);
                m.setAccessible(true);
                normalizeMethod = EntryStack.class.getDeclaredMethod("normalize", new Class[0]);
                normalizeMethod.setAccessible(true);
            }
            MethodHandle getListMethod = MethodHandles.publicLookup().unreflect(m);
            MethodHandle normalize = MethodHandles.publicLookup().unreflect(normalizeMethod);
            EntryRegistryImpl registry = (EntryRegistryImpl)EntryRegistry.getInstance();
            Supplier<Object> stackListSupplier = () -> {
                try {
                    return getListMethod.invokeExact(registry);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            };
            UnaryOperator normalizeOperator = o -> {
                try {
                    return normalize.invoke(o);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            };
            return new AsyncSearchManager(stackListSupplier, () -> Predicates.alwaysTrue(), normalizeOperator);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

