/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonizingStringMap<T>
implements Map<String, T> {
    private Object2ObjectMap<String, T> backingMap;
    private static final int GROWTH_THRESHOLD = 4;
    private static final Interner<String> KEY_INTERNER = Interners.newStrongInterner();

    public CanonizingStringMap() {
        this((Object2ObjectMap<String, T>)new Object2ObjectArrayMap());
    }

    protected CanonizingStringMap(Object2ObjectMap<String, T> newMap) {
        this.backingMap = newMap;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.backingMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.backingMap.containsValue(o);
    }

    @Override
    public T get(Object o) {
        return (T)this.backingMap.get(o);
    }

    @Override
    @Nullable
    public T put(String s, T t) {
        if (this.backingMap.size() >= 4 && !(this.backingMap instanceof Object2ObjectOpenHashMap) && !this.backingMap.containsKey((Object)s)) {
            this.backingMap = new Object2ObjectOpenHashMap(this.backingMap);
        }
        s = (String)KEY_INTERNER.intern((Object)s);
        return (T)this.backingMap.put((Object)s, t);
    }

    @Override
    public T remove(Object o) {
        Object value = this.backingMap.remove(o);
        if (this.backingMap.size() <= 4 && this.backingMap instanceof Object2ObjectOpenHashMap) {
            this.backingMap = new Object2ObjectArrayMap(this.backingMap);
        }
        return (T)value;
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends T> map) {
        if (map.size() == 0) {
            return;
        }
        if (map.size() - this.backingMap.size() > 4 && !(this.backingMap instanceof Object2ObjectOpenHashMap)) {
            this.backingMap = new Object2ObjectOpenHashMap(this.backingMap);
        }
        map.forEach((key, val) -> {
            key = (String)KEY_INTERNER.intern(key);
            this.backingMap.put(key, val);
        });
        if (this.backingMap.size() > 4 && !(this.backingMap instanceof Object2ObjectOpenHashMap)) {
            this.backingMap = new Object2ObjectOpenHashMap(this.backingMap);
        }
    }

    @Override
    public void clear() {
        if (!(this.backingMap instanceof Object2ObjectArrayMap)) {
            this.backingMap = new Object2ObjectArrayMap();
        } else {
            this.backingMap.clear();
        }
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return Collections.unmodifiableCollection(this.backingMap.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, T>> entrySet() {
        return Collections.unmodifiableSet(this.backingMap.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonizingStringMap that = (CanonizingStringMap)o;
        if (that.backingMap.size() != this.backingMap.size()) {
            return false;
        }
        return this.backingMap.object2ObjectEntrySet().containsAll((Collection)that.backingMap.object2ObjectEntrySet());
    }

    @Override
    public int hashCode() {
        ObjectIterator i = Object2ObjectMaps.fastIterator(this.backingMap);
        int h = 0;
        int n = this.backingMap.size();
        while (n-- != 0) {
            h += ((Object2ObjectMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    public static <T> CanonizingStringMap<T> deepCopy(CanonizingStringMap<T> inputMap, Function<T, T> deepCopier) {
        Objects.requireNonNull(deepCopier);
        int size = inputMap.backingMap.size();
        Object copiedBackingMap = size > 4 ? new Object2ObjectOpenHashMap(size) : new Object2ObjectArrayMap(size);
        inputMap.backingMap.object2ObjectEntrySet().forEach(arg_0 -> CanonizingStringMap.lambda$deepCopy$1((Object2ObjectMap)copiedBackingMap, deepCopier, arg_0));
        return new CanonizingStringMap<T>(copiedBackingMap);
    }

    private static /* synthetic */ void lambda$deepCopy$1(Object2ObjectMap copiedBackingMap, Function deepCopier, Object2ObjectMap.Entry entry) {
        if (entry.getKey() != null && entry.getValue() != null) {
            copiedBackingMap.put((Object)((String)entry.getKey()), deepCopier.apply(entry.getValue()));
        }
    }
}

