/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.config;

import java.nio.file.Path;
import mezz.jei.core.config.file.ConfigSchemaBuilder;
import mezz.jei.core.config.file.FileWatcher;
import mezz.jei.core.config.file.IConfigSchema;
import mezz.jei.gui.config.ClientConfig;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.config.IIngredientFilterConfig;
import mezz.jei.gui.config.IIngredientGridConfig;
import mezz.jei.gui.config.IJeiClientConfigs;
import mezz.jei.gui.config.IngredientFilterConfig;
import mezz.jei.gui.config.IngredientGridConfig;
import mezz.jei.gui.util.HorizontalAlignment;

public class JeiClientConfigs
implements IJeiClientConfigs {
    private final IClientConfig clientConfig;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IIngredientGridConfig ingredientListConfig;
    private final IIngredientGridConfig bookmarkListConfig;
    private final IConfigSchema schema;

    public JeiClientConfigs(Path configFile) {
        ConfigSchemaBuilder builder = new ConfigSchemaBuilder(configFile);
        this.clientConfig = new ClientConfig(builder);
        this.ingredientFilterConfig = new IngredientFilterConfig(builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", builder, HorizontalAlignment.LEFT);
        this.schema = builder.build();
    }

    public void register(FileWatcher fileWatcher) {
        this.schema.register(fileWatcher);
    }

    @Override
    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public IIngredientFilterConfig getIngredientFilterConfig() {
        return this.ingredientFilterConfig;
    }

    @Override
    public IIngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    @Override
    public IIngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }
}

