/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.vendored.joml.Matrix4f;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;

public class CenterDepthSampler {
    private static final double LN2 = Math.log(2.0);
    private final Program program;
    private final GlFramebuffer framebuffer;
    private final int texture = GlStateManager.m_84111_();
    private final int altTexture = GlStateManager.m_84111_();
    private boolean hasFirstSample;
    private boolean everRetrieved;

    public CenterDepthSampler(RenderTargets targets, float halfLife) {
        ProgramBuilder builder;
        this.framebuffer = new GlFramebuffer();
        InternalTextureFormat format = InternalTextureFormat.R32F;
        RenderSystem.m_69396_((int)this.texture);
        this.setupColorTexture(format);
        RenderSystem.m_69396_((int)this.altTexture);
        this.setupColorTexture(format);
        RenderSystem.m_69396_((int)0);
        this.framebuffer.addColorAttachment(0, this.texture);
        try {
            String fsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.fsh"))), StandardCharsets.UTF_8);
            String vsh = new String(IOUtils.toByteArray((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/centerDepth.vsh"))), StandardCharsets.UTF_8);
            builder = ProgramBuilder.begin("centerDepthSmooth", vsh, null, fsh, (ImmutableSet<Integer>)ImmutableSet.of());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        builder.addDynamicSampler(targets::getDepthTexture, "depth");
        builder.addDynamicSampler(() -> this.altTexture, "altDepth");
        builder.uniform1f(UniformUpdateFrequency.PER_FRAME, "lastFrameTime", SystemTimeUniforms.TIMER::getLastFrameTime);
        builder.uniform1f(UniformUpdateFrequency.ONCE, "decay", () -> 1.0 / ((double)halfLife * 0.1 / LN2));
        builder.uniformJomlMatrix(UniformUpdateFrequency.ONCE, "projection", () -> new Matrix4f(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f));
        this.program = builder.build();
    }

    public void sampleCenterDepth() {
        if (this.hasFirstSample && !this.everRetrieved) {
            return;
        }
        this.hasFirstSample = true;
        this.framebuffer.bind();
        this.program.use();
        RenderSystem.m_69949_((int)0, (int)0, (int)1, (int)1);
        FullScreenQuadRenderer.INSTANCE.render();
        ProgramUniforms.clearActiveUniforms();
        GlStateManager.m_84478_((int)0);
        this.framebuffer.bind();
        GlStateManager.m_84544_((int)this.altTexture);
        DepthCopyStrategy.fastest(false).copy(this.framebuffer, this.texture, null, this.altTexture, 1, 1);
        GlStateManager.m_84544_((int)0);
        Minecraft.m_91087_().m_91385_().m_83947_(true);
    }

    public void setupColorTexture(InternalTextureFormat format) {
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10242, (int)33071);
        RenderSystem.m_69937_((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)format.getGlFormat(), (int)1, (int)1, (int)0, (int)format.getPixelFormat().getGlFormat(), (int)PixelType.FLOAT.getGlFormat(), null);
    }

    public int getCenterDepthTexture() {
        this.everRetrieved = true;
        return this.altTexture;
    }

    public void destroy() {
        GlStateManager.m_84541_((int)this.texture);
        GlStateManager.m_84541_((int)this.altTexture);
        this.framebuffer.destroy();
        this.program.destroy();
    }
}

