/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.caffeinemc.phosphor.common.chunk.light.BlockLightStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockLightSectionStorage.class})
public abstract class MixinBlockLightStorage
extends MixinLightStorage
implements BlockLightStorageAccess {
    @Unique
    private final LongSet lightEnabled = new LongOpenHashSet();

    @Override
    protected void m_7358_(long chunkPos, boolean enable) {
        if (enable) {
            this.lightEnabled.add(chunkPos);
        } else {
            this.lightEnabled.remove(chunkPos);
        }
    }

    @Override
    public boolean isLightEnabled(long sectionPos) {
        return this.lightEnabled.contains(SectionPos.m_123240_((long)sectionPos));
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, DataLayer lightmap) {
        return newVal - oldVal;
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, DataLayer lightmap) {
        if (lightmap.m_62575_()) {
            return 0;
        }
        int complexity = 0;
        for (int y = 0; y < 16; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += lightmap.m_62560_(x, y, z);
                }
            }
        }
        return complexity;
    }

    @Override
    protected void beforeChunkEnabled(long chunkPos) {
    }

    @Override
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
    }
}

