/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp;

import net.devtech.arrp.api.RRPEventHelper;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.BRRPCubeBlock;
import net.devtech.arrp.generator.BRRPFenceBlock;
import net.devtech.arrp.generator.BRRPFenceGateBlock;
import net.devtech.arrp.generator.BRRPSlabBlock;
import net.devtech.arrp.generator.BRRPStairsBlock;
import net.devtech.arrp.generator.BRRPWallBlock;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.devtech.arrp.json.recipe.JStonecuttingRecipe;
import net.devtech.arrp.json.tags.IdentifiedTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.PlatformBridge;

@TestOnly
@ApiStatus.Internal
public class BRRPDevelopment {
    private static final RuntimeResourcePack PACK;
    public static final SoundType LAVA_SOUND_GROUP;
    private static final Logger LOGGER;
    public static final BRRPCubeBlock LAVA_BLOCK;
    public static final BRRPStairsBlock LAVA_STAIRS;
    public static final BRRPSlabBlock LAVA_SLAB;
    public static final BRRPFenceBlock LAVA_FENCE;
    public static final BRRPFenceGateBlock LAVA_FENCE_GATE;
    public static final BRRPWallBlock LAVA_WALL;
    public static final BRRPCubeBlock SMOOTH_STONE;

    private static BlockItem blockItem(Block block) {
        BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(CreativeModeTab.f_40752_));
        PlatformBridge.getInstance().registerItem(Registry.f_122824_.m_7981_((Object)block), (Item)item);
        return item;
    }

    private static RuntimeResourcePack refreshPack(boolean clientIncluded, boolean serverIncluded) {
        LOGGER.info("Generating resources for the development environment.");
        PACK.setForbidsDuplicateResource(true);
        if (clientIncluded) {
            PACK.clearResources(PackType.CLIENT_RESOURCES);
            PACK.mergeLang(new ResourceLocation("brrp", "en_us"), new JLang().blockRespect(LAVA_BLOCK, "Lava Block (Development Environment Only)").blockRespect((Block)LAVA_STAIRS, "Lava Stairs (Development Environment Only)").blockRespect((Block)LAVA_SLAB, "Lava Slab (Development Environment Only)").blockRespect((Block)LAVA_FENCE, "Lava Fence (Development Environment Only)").blockRespect((Block)LAVA_FENCE_GATE, "Lava Fence Gate (Development Environment Only)").blockRespect((Block)LAVA_WALL, "Lava Wall (Development Environment Only)").blockRespect(SMOOTH_STONE, "Smooth Stone (Development Environment Only)"));
            PACK.mergeLang(new ResourceLocation("brrp", "zh_cn"), new JLang().blockRespect(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u5757\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").blockRespect((Block)LAVA_STAIRS, "\u7194\u5ca9\u697c\u68af\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09"));
            PACK.mergeLang(new ResourceLocation("brrp", "zh_cn"), new JLang().blockRespect((Block)LAVA_SLAB, "\u7194\u5ca9\u53f0\u9636\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").blockRespect((Block)LAVA_FENCE, "\u7194\u5ca9\u6805\u680f\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09"));
            PACK.mergeLang(new ResourceLocation("brrp", "zh_cn"), new JLang().blockRespect((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u6805\u680f\u95e8\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").blockRespect((Block)LAVA_WALL, "\u7194\u5ca9\u5899\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").blockRespect(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u5934\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09"));
            JLang twLang = new JLang().blockRespect(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u584a\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_STAIRS, "\u7194\u5ca9\u968e\u68af\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_SLAB, "\u7194\u5ca9\u534a\u78da\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_FENCE, "\u7194\u5ca9\u67f5\u6b04\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u67f5\u6b04\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_WALL, "\u7194\u5ca9\u58bb\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u982d\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09");
            PACK.mergeLang(new ResourceLocation("brrp", "zh_tw"), twLang);
            PACK.mergeLang(new ResourceLocation("brrp", "zh_hk"), twLang.blockRespect((Block)LAVA_FENCE, "\u7194\u5ca9\u6b04\u6746\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").blockRespect((Block)LAVA_FENCE_GATE, "\u7194\u5ca9\u9598\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09"));
        }
        if (serverIncluded) {
            PACK.clearResources(PackType.SERVER_DATA);
            ((IdentifiedTag)new IdentifiedTag(BlockTags.f_13039_).addBlock((Block)LAVA_FENCE)).write(PACK);
            ((IdentifiedTag)new IdentifiedTag(BlockTags.f_13055_).addBlock((Block)LAVA_FENCE_GATE)).write(PACK);
            ((IdentifiedTag)new IdentifiedTag(BlockTags.f_13032_).addBlock((Block)LAVA_WALL)).write(PACK);
            ((IdentifiedTag)new IdentifiedTag(ItemTags.f_13147_).addItem((ItemLike)LAVA_FENCE)).write(PACK);
            ((IdentifiedTag)new IdentifiedTag(ItemTags.f_13140_).addItem((ItemLike)LAVA_WALL)).write(PACK);
            ((IdentifiedTag)new IdentifiedTag(BlockTags.f_144282_).addBlock(SMOOTH_STONE)).write(PACK);
            PACK.addRecipeAndAdvancement(new ResourceLocation("brrp", "smooth_stone"), "transportation", new JShapedRecipe((ItemLike)Blocks.f_50405_).resultCount(6).pattern("###").addKey("#", (ItemLike)SMOOTH_STONE).addInventoryChangedCriterion("has_smooth_stone", (ItemLike)SMOOTH_STONE));
            PACK.addRecipeAndAdvancement(new ResourceLocation("brrp", "smooth_stone_from_stonecutting"), "transportation", new JStonecuttingRecipe((ItemLike)SMOOTH_STONE, (ItemLike)Blocks.f_50405_, 2).addInventoryChangedCriterion("has_smooth_stone", (ItemLike)SMOOTH_STONE));
        }
        LAVA_BLOCK.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_STAIRS.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_SLAB.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE_GATE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_WALL.writeResources(PACK, clientIncluded, serverIncluded);
        SMOOTH_STONE.writeResources(PACK, clientIncluded, serverIncluded);
        LOGGER.info("Resources generation finished for the development environment.");
        return PACK;
    }

    @Contract(value="_,_ -> param1")
    private static <T extends Block> T register(T block, String name) {
        PlatformBridge.getInstance().registerBlock(new ResourceLocation("brrp", name), block);
        return block;
    }

    @ApiStatus.Internal
    public static void registerPacks() {
        RRPEventHelper.BEFORE_VANILLA.registerPack(resourceType -> switch (resourceType) {
            default -> throw new IncompatibleClassChangeError();
            case PackType.CLIENT_RESOURCES -> BRRPDevelopment.refreshPack(true, false);
            case PackType.SERVER_DATA -> BRRPDevelopment.refreshPack(false, true);
        });
    }

    static {
        Validate.isTrue((boolean)PlatformBridge.getInstance().isDevelopmentEnvironment(), (String)"The class 'BRRPDevelopment' should not be loaded out of the development environment.", (Object[])new Object[0]);
        PACK = RuntimeResourcePack.create(new ResourceLocation("brrp", "test"));
        LAVA_SOUND_GROUP = new SoundType(1.0f, 1.0f, SoundEvents.f_11780_, SoundEvents.f_12032_, SoundEvents.f_11783_, SoundEvents.f_12032_, SoundEvents.f_144127_);
        LOGGER = LoggerFactory.getLogger(BRRPDevelopment.class);
        LAVA_BLOCK = BRRPDevelopment.register(BRRPCubeBlock.cubeAll(BlockBehaviour.Properties.m_60939_((Material)new Material.Builder(MaterialColor.f_76402_).m_76354_().m_76353_().m_76350_().m_76359_()).m_60953_(state -> 15).m_60918_(LAVA_SOUND_GROUP), "block/lava_still"), "lava_block");
        LAVA_STAIRS = BRRPDevelopment.register(new BRRPStairsBlock(LAVA_BLOCK), "lava_stairs");
        LAVA_SLAB = BRRPDevelopment.register(new BRRPSlabBlock(LAVA_BLOCK), "lava_slab");
        LAVA_FENCE = BRRPDevelopment.register(new BRRPFenceBlock(LAVA_BLOCK), "lava_fence");
        LAVA_FENCE_GATE = BRRPDevelopment.register(new BRRPFenceGateBlock(LAVA_BLOCK), "lava_fence_gate");
        LAVA_WALL = BRRPDevelopment.register(new BRRPWallBlock(LAVA_BLOCK), "lava_wall");
        SMOOTH_STONE = BRRPDevelopment.register(BRRPCubeBlock.cubeBottomTop(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50470_), "block/smooth_stone", "block/smooth_stone_slab_side", "block/smooth_stone"), "smooth_stone");
        BRRPDevelopment.blockItem(LAVA_BLOCK);
        BRRPDevelopment.blockItem((Block)LAVA_STAIRS);
        BRRPDevelopment.blockItem((Block)LAVA_SLAB);
        BRRPDevelopment.blockItem((Block)LAVA_FENCE);
        BRRPDevelopment.blockItem((Block)LAVA_FENCE_GATE);
        BRRPDevelopment.blockItem((Block)LAVA_WALL);
        BRRPDevelopment.blockItem(SMOOTH_STONE);
    }
}

