/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface RuntimeResourcePack
extends PackResources {
    public static final Path DEFAULT_OUTPUT = Paths.get("rrp.debug", new String[0]);
    @ApiStatus.AvailableSince(value="0.6.2")
    public static final Gson GSON = RuntimeResourcePackImpl.GSON;

    @Contract(value="_ -> new")
    public static RuntimeResourcePack create(String id) {
        return new RuntimeResourcePackImpl(new ResourceLocation(id));
    }

    @Contract(value="_, _ -> new")
    public static RuntimeResourcePack create(String id, int version) {
        return new RuntimeResourcePackImpl(new ResourceLocation(id), version);
    }

    @Contract(value="_ -> new")
    public static RuntimeResourcePack create(ResourceLocation id) {
        return new RuntimeResourcePackImpl(id);
    }

    @Contract(value="_, _ -> new")
    public static RuntimeResourcePack create(ResourceLocation id, int version) {
        return new RuntimeResourcePackImpl(id, version);
    }

    public static ResourceLocation id(String string) {
        return new ResourceLocation(string);
    }

    public static ResourceLocation id(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    @ApiStatus.AvailableSince(value="0.7.0")
    @Contract(mutates="this")
    default public void setForbidsDuplicateResource(boolean b) {
    }

    @Contract(mutates="this")
    public void addRecoloredImage(ResourceLocation var1, InputStream var2, IntUnaryOperator var3);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addLang(ResourceLocation var1, JLang var2);

    @Contract(mutates="this")
    public void mergeLang(ResourceLocation var1, JLang var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addLootTable(ResourceLocation var1, JLootTable var2);

    @CanIgnoreReturnValue
    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(mutates="this")
    public byte[] addLootTable(ResourceLocation var1, LootTable var2);

    @Contract(mutates="this")
    public Future<byte[]> addAsyncResource(PackType var1, ResourceLocation var2, CallableFunction<ResourceLocation, byte[]> var3);

    @Contract(mutates="this")
    public void addLazyResource(PackType var1, ResourceLocation var2, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> var3);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addResource(PackType var1, ResourceLocation var2, byte[] var3);

    @Contract(mutates="this")
    public Future<byte[]> addAsyncRootResource(String var1, CallableFunction<String, byte[]> var2);

    @Contract(mutates="this")
    public void addLazyRootResource(String var1, BiFunction<RuntimeResourcePack, String, byte[]> var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addRootResource(String var1, byte[] var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addAsset(ResourceLocation var1, byte[] var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addData(ResourceLocation var1, byte[] var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addModel(JModel var1, ResourceLocation var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    default public byte[] addBlockState(JState state, ResourceLocation identifier) {
        return this.addBlockState(JBlockStates.of(state), identifier);
    }

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addBlockState(JBlockStates var1, ResourceLocation var2);

    @ApiStatus.AvailableSince(value="0.8.0")
    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addBlockState(BlockStateGenerator var1, ResourceLocation var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addTexture(ResourceLocation var1, BufferedImage var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addAnimation(ResourceLocation var1, JAnimation var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addTag(ResourceLocation var1, JTag var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addRecipe(ResourceLocation var1, JRecipe var2);

    @ApiStatus.AvailableSince(value="0.6.2")
    @CanIgnoreReturnValue
    @Contract(mutates="this")
    default public byte[] addRecipeAdvancement(ResourceLocation recipeId, ResourceLocation advancementId, JRecipe recipeContainingAdvancement) {
        Advancement.Builder advancement = recipeContainingAdvancement.asAdvancement();
        if (advancement != null && !advancement.m_138405_().isEmpty()) {
            recipeContainingAdvancement.prepareAdvancement(recipeId);
            return this.addAdvancement(advancementId, advancement);
        }
        return null;
    }

    @ApiStatus.AvailableSince(value="0.7.0")
    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(ResourceLocation recipeId, @Nullable String groupName, JRecipe recipeContainingAdvancement) {
        this.addRecipe(recipeId, recipeContainingAdvancement);
        this.addRecipeAdvancement(recipeId, recipeId.brrp_prepend("recipes/" + (String)(StringUtils.isEmpty((CharSequence)groupName) ? "" : groupName + "/")), recipeContainingAdvancement);
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addRecipe(ResourceLocation var1, FinishedRecipe var2);

    @CanIgnoreReturnValue
    @Contract(mutates="this")
    public byte[] addAdvancement(ResourceLocation var1, Advancement.Builder var2);

    public Future<?> async(Consumer<RuntimeResourcePack> var1);

    default public void dump() {
        this.dump(DEFAULT_OUTPUT);
    }

    public void dumpDirect(Path var1);

    public void load(Path var1) throws IOException;

    @Deprecated
    public void dump(File var1);

    default public void dump(Path path) {
        ResourceLocation id = this.getId();
        Path folder = path.resolve(id.m_135827_() + "_" + id.m_135815_());
        this.dumpDirect(folder);
    }

    public void dump(ZipOutputStream var1) throws IOException;

    public void load(ZipInputStream var1) throws IOException;

    @Contract(pure=true)
    public ResourceLocation getId();

    @Contract(mutates="this")
    public void clearResources(PackType var1);

    @Contract(mutates="this")
    public void clearResources();

    @ApiStatus.AvailableSince(value="0.7.0")
    @Contract(mutates="this")
    public void clearRootResources();

    @ApiStatus.AvailableSince(value="0.9.0")
    default public Component getDisplayName() {
        return Component.m_237110_((String)"brrp.pack_display_name", (Object[])new Object[]{this.getId()});
    }

    @ApiStatus.AvailableSince(value="0.9.0")
    default public Component getDescription() {
        return Component.m_237115_((String)"brrp.pack_description");
    }
}

