/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.BlockResourceGenerator;
import net.devtech.arrp.generator.ResourceGeneratorHelper;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class BRRPSlabBlock
extends SlabBlock
implements BlockResourceGenerator {
    @Nullable
    public final Block baseBlock;

    @Override
    @Nullable
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public BRRPSlabBlock(@NotNull Block baseBlock) {
        this(baseBlock, BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock));
    }

    public BRRPSlabBlock(@Nullable Block baseBlock, BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = baseBlock;
    }

    public BRRPSlabBlock(BlockBehaviour.Properties settings) {
        this(null, settings);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JBlockStates getBlockStates() {
        ResourceLocation id = this.getBlockModelId();
        return JBlockStates.simpleSlab(this.baseBlock != null ? ResourceGeneratorHelper.getBlockModelId(this.baseBlock) : id.brrp_append("_double"), id, id.brrp_append("_top"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public @UnknownNullability JModel getBlockModel() {
        return new JModel("block/slab").textures(JTextures.ofSides(this.getTextureId(TextureSlot.f_125872_), this.getTextureId(TextureSlot.f_125875_), this.getTextureId(TextureSlot.f_125871_)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void writeBlockModel(RuntimeResourcePack pack) {
        JModel model = this.getBlockModel();
        ResourceLocation id = this.getBlockModelId();
        pack.addModel(model, id);
        pack.addModel(model.clone().parent("block/slab_top"), id.brrp_append("_top"));
        if (this.baseBlock == null) {
            pack.addModel(model.clone().parent("block/cube_bottom_top"), id.brrp_append("_double"));
        }
    }

    @Override
    public JLootTable getLootTable() {
        return JLootTable.delegate(BlockLoot.m_124290_((Block)this));
    }

    @Override
    public @UnknownNullability(value="Null if the base block is null.") JRecipe getCraftingRecipe() {
        return this.baseBlock == null ? null : new JShapedRecipe((ItemLike)this).resultCount(6).pattern("###").addKey("#", (ItemLike)this.baseBlock).addInventoryChangedCriterion("has_ingredient", (ItemLike)this.baseBlock);
    }
}

