/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.generator;

import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.generator.ItemResourceGenerator;
import net.devtech.arrp.generator.ResourceGeneratorHelper;
import net.devtech.arrp.generator.TextureRegistry;
import net.devtech.arrp.json.blockstate.JBlockStates;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.minecraft.core.Registry;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BlockResourceGenerator
extends ItemResourceGenerator {
    @Contract(pure=true)
    @Nullable
    default public Block getBaseBlock() {
        return null;
    }

    @Contract(pure=true)
    default public ResourceLocation getBlockId() {
        return Registry.f_122824_.m_7981_((Object)((Block)this));
    }

    @Override
    @Contract(pure=true)
    default public ResourceLocation getItemId() {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof Block) {
            Block block = (Block)blockResourceGenerator;
            Item item = block.m_5456_();
            if (item == Items.f_41852_) {
                if (BlockItem.f_41373_.containsKey(block)) {
                    return Registry.f_122827_.m_7981_((Object)((Item)BlockItem.f_41373_.get(block)));
                }
                return null;
            }
            return Registry.f_122827_.m_7981_((Object)item);
        }
        return null;
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    default public ResourceLocation getBlockModelId() {
        return this.getBlockId().brrp_prepend("block/");
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    @NotNull
    default public String getTextureId(@NotNull TextureSlot textureKey) {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof Block) {
            Block thisBlock = (Block)blockResourceGenerator;
            ResourceLocation texture = TextureRegistry.getTexture(thisBlock, textureKey);
            if (texture != null) {
                return texture.toString();
            }
            @Nullable Block baseBlock = this.getBaseBlock();
            if (baseBlock != null) {
                return ResourceGeneratorHelper.getTextureId(baseBlock, textureKey);
            }
        }
        return this.getBlockId().brrp_prepend("block/").toString();
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    @Nullable
    default public JBlockStates getBlockStates() {
        return null;
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockStates(RuntimeResourcePack pack) {
        JBlockStates blockStates = this.getBlockStates();
        if (blockStates != null) {
            pack.addBlockState(blockStates, this.getBlockId());
        }
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    @Nullable
    default public JModel getBlockModel() {
        return null;
    }

    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockModel(RuntimeResourcePack pack) {
        JModel model = this.getBlockModel();
        if (model != null) {
            pack.addModel(model, this.getBlockModelId());
        }
    }

    @Override
    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    default public ResourceLocation getItemModelId() {
        ResourceLocation itemId = this.getItemId();
        if (itemId == null) {
            return null;
        }
        return itemId.brrp_prepend("item/");
    }

    @Override
    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        JModel model;
        ResourceLocation itemModelId = this.getItemModelId();
        if (itemModelId != null && (model = this.getItemModel()) != null) {
            pack.addModel(model, itemModelId);
        }
    }

    @Override
    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(pure=true)
    @Nullable
    default public JModel getItemModel() {
        return new JModel(this.getBlockModelId());
    }

    @Override
    @PreferredEnvironment(value=Dist.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeBlockStates(pack);
        this.writeBlockModel(pack);
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    default public ResourceLocation getLootTableId() {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof BlockBehaviour) {
            BlockBehaviour block = (BlockBehaviour)blockResourceGenerator;
            return block.m_60589_();
        }
        return this.getBlockId().brrp_prepend("blocks/");
    }

    @Contract(pure=true)
    default public JLootTable getLootTable() {
        return JLootTable.simple(this.getItemId().toString());
    }

    @Contract(mutates="param1")
    default public void writeLootTable(RuntimeResourcePack pack) {
        JLootTable lootTable = this.getLootTable();
        if (lootTable != null) {
            pack.addLootTable(this.getLootTableId(), lootTable);
        }
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    @Contract(pure=true)
    @Nullable
    default public JRecipe getStonecuttingRecipe() {
        return null;
    }

    @ApiStatus.AvailableSince(value="0.6.2")
    @Contract(pure=true)
    default public boolean shouldWriteStonecuttingRecipe() {
        return false;
    }

    @Override
    @ApiStatus.AvailableSince(value="0.6.2")
    default public void writeRecipes(RuntimeResourcePack pack) {
        JRecipe stonecuttingRecipe;
        ItemResourceGenerator.super.writeRecipes(pack);
        if (this.shouldWriteStonecuttingRecipe() && (stonecuttingRecipe = this.getStonecuttingRecipe()) != null) {
            ResourceLocation stonecuttingRecipeId = this.getStonecuttingRecipeId();
            pack.addRecipe(stonecuttingRecipeId, stonecuttingRecipe);
            pack.addRecipeAdvancement(stonecuttingRecipeId, this.getAdvancementIdForRecipe(stonecuttingRecipeId), stonecuttingRecipe);
        }
    }

    @NotNull
    @ApiStatus.AvailableSince(value="0.6.2")
    @Contract(pure=true)
    default public ResourceLocation getStonecuttingRecipeId() {
        return this.getRecipeId().brrp_append("_from_stonecutting");
    }

    @Override
    default public void writeData(RuntimeResourcePack pack) {
        this.writeLootTable(pack);
        this.writeRecipes(pack);
    }
}

