/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.animation;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.animation.JFrame;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JAnimation
implements Cloneable,
JsonSerializable {
    private Boolean interpolate;
    private Integer width;
    private Integer height;
    private Integer frametime;
    private List<JFrame> frames;
    private IntList defaultFrames;

    @Deprecated
    public static JAnimation animation() {
        return new JAnimation();
    }

    @Deprecated
    public static JFrame frame(int index) {
        return new JFrame(index);
    }

    public JAnimation clone() {
        try {
            return (JAnimation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public JAnimation interpolate() {
        this.interpolate = true;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation interpolate(boolean interpolate) {
        this.interpolate = interpolate;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation width(int width) {
        this.width = width;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation height(int height) {
        this.height = height;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation frameTime(int time) {
        this.frametime = time;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation add(int frame) {
        if (this.defaultFrames == null) {
            this.defaultFrames = new IntArrayList();
        }
        this.defaultFrames.add(frame);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation add(JFrame frame) {
        if (this.frames == null) {
            this.frames = new ArrayList<JFrame>();
        }
        this.frames.add(frame);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JAnimation addFrame(int index) {
        return this.add(new JFrame(index));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JAnimation addFrame(int index, int time) {
        return this.add(new JFrame(index, time));
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonObject animation = new JsonObject();
        if (this.interpolate != null) {
            animation.addProperty("interpolate", this.interpolate);
        }
        if (this.width != null) {
            animation.addProperty("width", (Number)this.width);
        }
        if (this.height != null) {
            animation.addProperty("height", (Number)this.height);
        }
        if (this.frametime != null) {
            animation.addProperty("frametime", (Number)this.frametime);
        }
        JsonArray frames = new JsonArray();
        if (this.frames != null) {
            for (JFrame frame : this.frames) {
                frames.add(context.serialize((Object)frame));
            }
        }
        if (this.defaultFrames != null) {
            IntListIterator intListIterator = this.defaultFrames.iterator();
            while (intListIterator.hasNext()) {
                int frame = (Integer)intListIterator.next();
                frames.add((Number)frame);
            }
        }
        if (frames.size() > 0) {
            animation.add("frames", (JsonElement)frames);
        }
        object.add("animation", (JsonElement)animation);
        return object;
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JAnimation> {
        public JsonElement serialize(JAnimation jAnimation, Type type, JsonSerializationContext jsonSerializationContext) {
            return jAnimation.serialize(type, jsonSerializationContext);
        }
    }
}

