/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@PreferredEnvironment(value=Dist.CLIENT)
public class JBlockModel
implements Cloneable {
    public ResourceLocation model;
    @Nullable
    public Integer x;
    @Nullable
    public Integer y;
    @Nullable
    public Boolean uvlock;
    @Nullable
    public Integer weight;

    public JBlockModel(ResourceLocation model, @Nullable Integer x, @Nullable Integer y, @Nullable Boolean uvlock, @Nullable Integer weight) {
        this.model = model;
        this.x = x;
        this.y = y;
        this.uvlock = uvlock;
        this.weight = weight;
    }

    public JBlockModel() {
    }

    @Deprecated
    public JBlockModel(String modelId) {
        this(new ResourceLocation(modelId));
    }

    public JBlockModel(ResourceLocation modelId) {
        this.model = modelId;
    }

    public JBlockModel(String idNamespace, String idPath) {
        this(new ResourceLocation(idNamespace, idPath));
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockModel[] simpleRandom(JBlockModel basicModel) {
        JBlockModel[] multiple = new JBlockModel[4];
        for (int i = 0; i < 4; ++i) {
            JBlockModel cloned = basicModel.clone();
            cloned.y = 90 * i;
            multiple[i] = cloned;
        }
        return multiple;
    }

    public JBlockModel clone() {
        try {
            return (JBlockModel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JBlockModel modelId(ResourceLocation model) {
        this.model = model;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JBlockModel x(int x) {
        this.x = x;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JBlockModel y(int y) {
        this.y = y;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="-> this", mutates="this")
    public JBlockModel uvlock() {
        this.uvlock = true;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JBlockModel uvlock(boolean uvlock) {
        this.uvlock = uvlock;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JBlockModel weight(int weight) {
        this.weight = weight;
        return this;
    }
}

