/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.blockstate.JWhen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Contract;

@Deprecated
@PreferredEnvironment(value=Dist.CLIENT)
public final class JState
implements JsonSerializable {
    final List<JVariant> variants = new ArrayList<JVariant>();
    final List<JMultipart> multiparts = new ArrayList<JMultipart>();

    @Deprecated
    public static JState state() {
        return new JState();
    }

    @Deprecated
    public static JState state(JVariant ... variants) {
        JState state = new JState();
        for (JVariant variant : variants) {
            state.add(variant);
        }
        return state;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JState add(JVariant variant) {
        if (!this.multiparts.isEmpty()) {
            throw new IllegalStateException("BlockStates can only have variants *or* multiparts, not both");
        }
        this.variants.add(variant);
        return this;
    }

    @Deprecated
    public static JState state(JMultipart ... parts) {
        JState state = new JState();
        for (JMultipart part : parts) {
            state.add(part);
        }
        return state;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JState add(JMultipart multiparts) {
        if (!this.variants.isEmpty()) {
            throw new IllegalStateException("BlockStates can only have variants *or* multiparts, not both");
        }
        this.multiparts.add(multiparts);
        return this;
    }

    @Deprecated
    public static JVariant variant() {
        return new JVariant();
    }

    @Deprecated
    public static JVariant variant(JBlockModel model) {
        JVariant variant = new JVariant();
        variant.put("", model);
        return variant;
    }

    @Deprecated
    public static JBlockModel model(String id) {
        return new JBlockModel(id);
    }

    @Deprecated
    public static JBlockModel model(ResourceLocation id) {
        return new JBlockModel(id);
    }

    @Deprecated
    public static JMultipart multipart(JBlockModel ... models) {
        JMultipart multipart = new JMultipart();
        for (JBlockModel model : models) {
            multipart.addModel(model);
        }
        return multipart;
    }

    @Deprecated
    public static JWhen when() {
        return new JWhen();
    }

    public static JWhen.StateBuilder whenStateBuilder() {
        return new JWhen.StateBuilder();
    }

    @Deprecated
    public JState clone() {
        try {
            return (JState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        if (!this.variants.isEmpty()) {
            if (this.variants.size() == 1) {
                json.add("variants", context.serialize((Object)this.variants.get(0)));
            } else {
                json.add("variants", context.serialize(this.variants));
            }
        }
        if (!this.multiparts.isEmpty()) {
            json.add("multipart", context.serialize(this.multiparts));
        }
        return json;
    }
}

