/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.blockstate;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.blockstate.JBlockModel;
import net.devtech.arrp.json.blockstate.JVariant;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PreferredEnvironment(value=Dist.CLIENT)
public class JVariants
extends ForwardingMap<String, JBlockModel[]>
implements JsonSerializable {
    private final Map<String, JBlockModel[]> variants;

    public JVariants() {
        this(new LinkedHashMap<String, JBlockModel[]>());
    }

    public JVariants(Map<String, JBlockModel[]> variants) {
        this.variants = variants;
    }

    @Contract(value="_ -> new")
    public static JVariants upgrade(JVariant jVariant) {
        JVariants instance = new JVariants();
        jVariant.models.forEach((k, v) -> instance.put((String)k, (JBlockModel[])v.toArray(JBlockModel[]::new)));
        return instance;
    }

    @Contract(value="_ -> new", pure=true)
    public static JVariants ofNoVariants(JBlockModel ... modelDefinition) {
        return JVariants.of("", modelDefinition);
    }

    @Contract(value="_ -> new", pure=true)
    public static JBlockModel[] ofRandomRotation(JBlockModel model) {
        JBlockModel[] result = new JBlockModel[4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = model.clone().y(90 * i);
        }
        return result;
    }

    @Contract(value="_ -> new", pure=true)
    public static JVariants ofHorizontalFacing(JBlockModel model) {
        JVariants JVariants2 = new JVariants();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            JVariants2.addVariant((Property)BlockStateProperties.f_61374_, (Comparable)direction, model.clone().y((int)direction.m_122435_()));
        }
        return JVariants2;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static JVariants ofSlab(JBlockModel model, ResourceLocation bottomSlabIdentifier, ResourceLocation topSlabIdentifier) {
        return new JVariants().addVariant((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.BOTTOM, model.clone().modelId(bottomSlabIdentifier)).addVariant((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.TOP, model.clone().modelId(topSlabIdentifier)).addVariant((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE, model);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JVariants of(String variant, JBlockModel ... modelDefinition) {
        return new JVariants().addVariant(variant, modelDefinition);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static JVariants of(String property, String value, JBlockModel ... modelDefinition) {
        return new JVariants().addVariant(property, value, modelDefinition);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static JVariants of(String property, StringRepresentable value, JBlockModel ... modelDefinition) {
        return new JVariants().addVariant(property, value, modelDefinition);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <T extends Comparable<T>> JVariants of(Property<T> property, T value, JBlockModel ... modelDefinition) {
        return new JVariants().addVariant(property, value, modelDefinition);
    }

    @Contract(value="_ -> new", pure=true)
    public static JVariants delegate(Variant delegate) {
        return new Delegate(delegate);
    }

    @NotNull
    protected Map<String, JBlockModel[]> delegate() {
        return this.variants;
    }

    @Contract(value="_, _ -> new", pure=true)
    public JVariants composeToSlab(Function<ResourceLocation, ResourceLocation> bottomSlabIdFunction, Function<ResourceLocation, ResourceLocation> topSlabIdFunction) {
        JVariants result = new JVariants();
        this.forEach((property, models) -> {
            if (!((String)property).isEmpty()) {
                property = (String)property + ",";
            }
            result.put((String)property + "type=double", (JBlockModel)models);
            result.put((String)property + "type=bottom", (JBlockModel[])Arrays.stream(models).map(model -> model.clone().modelId((ResourceLocation)bottomSlabIdFunction.apply(model.model))).toArray(JBlockModel[]::new));
            result.put((String)property + "type=top", (JBlockModel[])Arrays.stream(models).map(model -> model.clone().modelId((ResourceLocation)topSlabIdFunction.apply(model.model))).toArray(JBlockModel[]::new));
        });
        return result;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _-> this", mutates="this")
    public JVariants addVariant(String variant, JBlockModel ... modelDefinition) {
        this.put(variant, modelDefinition);
        return this;
    }

    public JBlockModel[] put(String key, JBlockModel ... value) {
        return (JBlockModel[])super.put((Object)key, (Object)value);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public <T extends Comparable<T>> JVariants addVariant(Property<T> property, T value, JBlockModel ... modelDefinition) {
        return this.addVariant(property.m_61708_() + "=" + property.m_6940_(value), modelDefinition);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public JVariants addVariant(String property, String value, JBlockModel ... modelDefinition) {
        return this.addVariant(property + "=" + value, modelDefinition);
    }

    @CanIgnoreReturnValue
    @Contract(value="_,_,_ -> this", mutates="this")
    public JVariants addVariant(String property, StringRepresentable value, JBlockModel ... modelDefinition) {
        return this.addVariant(property, value.m_7912_(), modelDefinition);
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.forEach((key, value) -> object.add(key, context.serialize(((JBlockModel[])value).length == 1 ? value[0] : value)));
        return object;
    }

    public JVariants clone() {
        return new JVariants(Maps.newLinkedHashMap(this.variants));
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JVariants
    implements JsonSerializable,
    Supplier<JsonElement> {
        private final Variant delegate;

        private Delegate(Variant delegate) {
            this.delegate = delegate;
        }

        @Override
        public JsonElement get() {
            return (JsonElement)this.delegate.get();
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return (JsonElement)this.delegate.get();
        }
    }
}

