/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JCondition
implements Cloneable,
JsonSerializable {
    public String condition;
    public JsonObject parameters;

    public JCondition(String condition, JsonObject parameters) {
        this.condition = condition;
        this.parameters = parameters;
    }

    public JCondition(String condition) {
        this(condition, new JsonObject());
    }

    public JCondition() {
        this(new JsonObject());
    }

    public JCondition(JsonObject parameters) {
        this.parameters = parameters;
        if (parameters.has("condition")) {
            this.condition = parameters.get("condition").getAsString();
        }
    }

    @Contract(value="_ -> new")
    public static JCondition ofAlternative(Iterable<JCondition> conditions) {
        JCondition result = new JCondition("alternative");
        result.parameters.add("terms", RuntimeResourcePackImpl.GSON.toJsonTree(conditions));
        return result;
    }

    @Contract(value="_ -> new", pure=true)
    public static JCondition ofAlternative(Collection<JCondition> conditions) {
        return JCondition.ofAlternative(conditions);
    }

    @Contract(value="_ -> new", pure=true)
    public static JCondition ofAlternative(JCondition ... conditions) {
        return JCondition.ofAlternative(Arrays.asList(conditions));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> new", mutates="this")
    public JCondition condition(String condition) {
        this.condition = condition;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> new", mutates="this")
    public JCondition set(JsonObject parameters) {
        parameters.addProperty("condition", this.parameters.get("condition").getAsString());
        this.parameters = parameters;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, Number value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, JsonElement value) {
        this.parameters.add(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, Boolean value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, Character value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, ResourceLocation value) {
        return this.parameter(key, value.toString());
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JCondition parameter(String key, String value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @Deprecated
    public JCondition alternative(JCondition ... conditions) {
        JsonArray array = new JsonArray();
        for (JCondition condition : conditions) {
            array.add(RuntimeResourcePackImpl.GSON.toJsonTree((Object)condition));
        }
        this.parameters.add("terms", (JsonElement)array);
        return this;
    }

    public JCondition clone() {
        try {
            return (JCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject parameters = this.parameters;
        parameters.addProperty("condition", this.condition);
        return parameters;
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new", pure=true)
    public static JCondition delegate(LootItemCondition vanillaCondition) {
        return new Delegate(vanillaCondition);
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> new", pure=true)
    public static JCondition delegate(LootItemCondition.Builder vanillaCondition) {
        return new Delegate(vanillaCondition.m_6409_());
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JCondition {
        private static final Gson GSON = Deserializers.m_78798_().create();
        private final LootItemCondition delegate;

        private Delegate(LootItemCondition delegate) {
            super(null, null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)this.delegate);
        }
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JCondition> {
        public JsonElement serialize(JCondition src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize(typeOfSrc, context);
        }
    }
}

