/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.loot.JCondition;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JFunction
implements Cloneable,
JsonSerializable {
    public List<JCondition> conditions;
    public String function;
    public JsonObject properties = new JsonObject();

    public JFunction(String function) {
        this.function(function);
    }

    @Contract(value="_ -> new")
    public static JFunction delegate(LootItemFunction delegate) {
        return new FromLootFunction(delegate);
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.8.0")
    public static JFunction delegate(LootItemFunction.Builder delegate) {
        return new FromLootFunctionBuilder(delegate);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFunction function(String function) {
        this.function = function;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.2")
    public JFunction function(ResourceLocation function) {
        return this.function(function.toString());
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.2")
    public JFunction function(LootItemFunctionType function) {
        return this.function(Objects.requireNonNull(Registry.f_122876_.m_7981_((Object)function), "The loot function type is not registered."));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFunction set(JsonObject properties) {
        this.properties = properties;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, JsonElement value) {
        this.properties.add(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, String value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, Number value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, Boolean value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, ResourceLocation value) {
        return this.parameter(key, value.toString());
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JFunction parameter(String key, Character value) {
        return this.parameter(key, (JsonElement)new JsonPrimitive(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JFunction condition(JCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>();
        }
        this.conditions.add(condition);
        return this;
    }

    @Deprecated
    public JFunction add(JCondition condition) {
        return this.condition(condition);
    }

    public JFunction clone() {
        try {
            return (JFunction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        if (this.conditions != null) {
            this.properties.add("conditions", context.serialize(this.conditions));
        }
        if (this.function != null) {
            this.properties.addProperty("function", this.function);
        }
        return this.properties;
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @ApiStatus.Internal
    private static class FromLootFunction
    extends JFunction {
        private static final Gson GSON = Deserializers.m_78799_().create();
        private final LootItemFunction delegate;

        public FromLootFunction(LootItemFunction delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)this.delegate);
        }
    }

    @ApiStatus.AvailableSince(value="0.8.0")
    @ApiStatus.Internal
    private static class FromLootFunctionBuilder
    extends JFunction {
        private final LootItemFunction.Builder delegate;

        public FromLootFunctionBuilder(LootItemFunction.Builder delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return FromLootFunction.GSON.toJsonTree((Object)this.delegate.m_7453_());
        }
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JFunction> {
        public JsonElement serialize(JFunction src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize(typeOfSrc, context);
        }
    }
}

