/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JPool;
import net.devtech.arrp.json.loot.JRoll;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JLootTable
implements Cloneable {
    public final String type;
    public List<JPool> pools;
    public List<JFunction> functions;

    public JLootTable(String type) {
        this.type = type;
    }

    public JLootTable(String type, JPool pool) {
        this(type, Lists.newArrayList((Object[])new JPool[]{pool}));
    }

    public JLootTable(String type, JPool ... pools) {
        this(type, Lists.newArrayList((Object[])pools));
    }

    public JLootTable(String type, List<JPool> pools) {
        this(type);
        this.pools = pools;
    }

    @Deprecated
    public static JLootTable loot(String type) {
        return new JLootTable(type);
    }

    @Deprecated
    public static JEntry entry() {
        return new JEntry();
    }

    @Deprecated
    public static JCondition condition(String condition) {
        return new JCondition(condition);
    }

    @Deprecated
    public static JCondition predicate(String condition) {
        return new JCondition(condition);
    }

    @Deprecated
    public static JFunction function(String function) {
        return new JFunction(function);
    }

    @Deprecated
    public static JPool pool() {
        return new JPool();
    }

    @Deprecated
    public static JRoll roll(int min, int max) {
        return new JRoll(min, max);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JLootTable pool(JPool pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<JPool>(1);
        }
        this.pools.add(pool);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JLootTable pool(LootPool pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<JPool>(1);
        }
        this.pools.add(JPool.delegate(pool));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JLootTable pool(LootPool.Builder pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<JPool>(1);
        }
        this.pools.add(JPool.delegate(pool.m_79082_()));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JLootTable function(JFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<JFunction>(1);
        }
        this.functions.add(function);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JLootTable function(LootItemFunction function) {
        return this.function(JFunction.delegate(function));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JLootTable function(LootItemFunction.Builder function) {
        return this.function(JFunction.delegate(function));
    }

    @Contract(value="_ -> new", pure=true)
    public static JLootTable simple(String blockId) {
        return new JLootTable("minecraft:block").pool(JPool.simple(blockId).condition(new JCondition("survives_explosion")));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JLootTable ofPools(String type, List<JPool> pools) {
        return new JLootTable(type, pools);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JLootTable ofPools(String type, JPool ... pools) {
        return JLootTable.ofPools(type, Lists.newArrayList((Object[])pools));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JLootTable ofEntries(String type, List<JEntry> entries) {
        return JLootTable.ofPools(type, JPool.ofEntries(entries));
    }

    @Contract(value="_, _ -> new", pure=true)
    public static JLootTable ofEntries(String type, JEntry ... entries) {
        return JLootTable.ofPools(type, JPool.ofEntries(entries));
    }

    @Deprecated
    @Contract(value="_ -> new")
    public static JLootTable delegate(LootTable delegate) {
        return new FromLootTable(delegate);
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.8.0")
    public static JLootTable delegate(LootTable.Builder delegate) {
        return new FromLootTableBuilder(delegate);
    }

    public JLootTable clone() {
        try {
            return (JLootTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @ApiStatus.Internal
    private static final class FromLootTable
    extends JLootTable
    implements JsonSerializable {
        private final transient LootTable delegate;
        private static final Gson GSON = Deserializers.m_78800_().create();

        public FromLootTable(LootTable lootTable) {
            super(null);
            this.delegate = lootTable;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)this.delegate);
        }
    }

    @ApiStatus.Internal
    @ApiStatus.AvailableSince(value="0.8.0")
    private static final class FromLootTableBuilder
    extends JLootTable
    implements JsonSerializable {
        private final transient LootTable.Builder delegate;

        private FromLootTableBuilder(LootTable.Builder delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        public JLootTable function(JFunction function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JLootTable function(LootItemFunction function) {
            this.delegate.m_79078_(() -> function);
            return this;
        }

        @Override
        public JLootTable function(LootItemFunction.Builder function) {
            this.delegate.m_79078_(function);
            return this;
        }

        @Override
        public JLootTable pool(final LootPool pool) {
            this.delegate.m_79161_(new LootPool.Builder(){

                public LootPool m_79082_() {
                    return pool;
                }
            });
            return this;
        }

        @Override
        public JLootTable pool(LootPool.Builder pool) {
            this.delegate.m_79161_(pool);
            return this;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return FromLootTable.GSON.toJsonTree((Object)this.delegate.m_79167_());
        }
    }
}

