/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JRoll;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JPool
implements Cloneable {
    public List<JCondition> conditions;
    public List<JFunction> functions;
    public List<JEntry> entries;
    @SerializedName(value="rolls")
    public NumberProvider rolls;
    @SerializedName(value="bonus_rolls")
    public NumberProvider bonusRolls;

    @Contract(value="_ -> new", pure=true)
    public static JPool simple(String itemId) {
        return JPool.ofEntries(new JEntry("item", itemId));
    }

    @Contract(value="_ -> new", pure=true)
    public static JPool ofEntries(List<JEntry> entries) {
        JPool pool = new JPool().rolls(1).bonus(1);
        pool.entries = entries;
        return pool;
    }

    @Contract(value="_ -> new", pure=true)
    public static JPool ofEntries(JEntry ... entries) {
        return JPool.ofEntries(Lists.newArrayList((Object[])entries));
    }

    @Contract(value="_ -> new")
    public static JPool delegate(LootPool delegate) {
        return new Delegate(delegate);
    }

    @Contract(value="_ -> new")
    @ApiStatus.AvailableSince(value="0.8.0")
    public static JPool delegate(LootPool.Builder delegate) {
        return new DelegateFromBuilder(delegate);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JPool entry(JEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<JEntry>(4);
        }
        this.entries.add(entry);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JPool entry(LootPoolEntryContainer entry) {
        return this.entry(JEntry.delegate(entry));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public <T extends LootPoolEntryContainer.Builder<T>> JPool entry(LootPoolEntryContainer.Builder<T> entry) {
        return this.entry(JEntry.delegate(entry));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JPool condition(JCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>(4);
        }
        this.conditions.add(condition);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JPool condition(LootItemCondition condition) {
        return this.condition(JCondition.delegate(condition));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    @ApiStatus.AvailableSince(value="0.8.0")
    public JPool condition(LootItemCondition.Builder condition) {
        return this.condition(JCondition.delegate(condition));
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JPool function(JFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<JFunction>(4);
        }
        this.functions.add(function);
        return this;
    }

    @CanIgnoreReturnValue
    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> this", mutates="this")
    public JPool function(LootItemFunction function) {
        return this.function(JFunction.delegate(function));
    }

    @CanIgnoreReturnValue
    @ApiStatus.AvailableSince(value="0.8.0")
    @Contract(value="_ -> this", mutates="this")
    public JPool function(LootItemFunction.Builder function) {
        return this.function(JFunction.delegate(function));
    }

    @Deprecated
    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool rolls(Integer rolls) {
        return this.rolls((NumberProvider)ConstantValue.m_165692_((float)rolls.intValue()));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool rolls(int rolls) {
        return this.rolls((NumberProvider)ConstantValue.m_165692_((float)rolls));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool rolls(float rolls) {
        return this.rolls((NumberProvider)ConstantValue.m_165692_((float)rolls));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool rolls(NumberProvider rolls) {
        this.rolls = rolls;
        return this;
    }

    @Deprecated
    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool rolls(JRoll roll) {
        return this.rolls(roll.asLootNumberProvider());
    }

    @Deprecated
    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool bonus(Integer bonus_rolls) {
        return this.bonus((NumberProvider)ConstantValue.m_165692_((float)bonus_rolls.intValue()));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool bonus(int bonus_rolls) {
        return this.bonus((NumberProvider)ConstantValue.m_165692_((float)bonus_rolls));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool bonus(float bonus_rolls) {
        return this.bonus((NumberProvider)ConstantValue.m_165692_((float)bonus_rolls));
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool bonus(NumberProvider bonusRollsProvider) {
        this.bonusRolls = bonusRollsProvider;
        return this;
    }

    @Deprecated
    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JPool bonus(JRoll bonus_roll) {
        return this.bonus(bonus_roll.asLootNumberProvider());
    }

    public JPool clone() {
        try {
            return (JPool)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JPool
    implements JsonSerializable {
        private final LootPool delegate;
        private static final Gson GSON = Deserializers.m_78800_().create();

        private Delegate(LootPool delegate) {
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return GSON.toJsonTree((Object)this.delegate);
        }
    }

    @ApiStatus.Internal
    private static final class DelegateFromBuilder
    extends JPool
    implements JsonSerializable {
        private final LootPool.Builder delegate;

        private DelegateFromBuilder(LootPool.Builder delegate) {
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return Delegate.GSON.toJsonTree((Object)this.delegate.m_79082_());
        }

        @Override
        public JPool rolls(NumberProvider rolls) {
            this.delegate.m_165133_(rolls);
            return this;
        }

        @Override
        public JPool bonus(NumberProvider bonusRollsProvider) {
            this.delegate.m_165135_(bonusRollsProvider);
            return this;
        }

        @Override
        public JPool condition(LootItemCondition condition) {
            this.delegate.m_79080_(() -> condition);
            return this;
        }

        @Override
        public JPool condition(LootItemCondition.Builder condition) {
            this.delegate.m_79080_(condition);
            return this;
        }

        @Override
        public JPool entry(final LootPoolEntryContainer entry) {
            this.delegate.m_79076_(new LootPoolEntryContainer.Builder(){

                protected LootPoolEntryContainer.Builder m_6897_() {
                    return this;
                }

                public LootPoolEntryContainer m_7512_() {
                    return entry;
                }
            });
            return this;
        }

        @Override
        public <T extends LootPoolEntryContainer.Builder<T>> JPool entry(LootPoolEntryContainer.Builder<T> entry) {
            this.delegate.m_79076_(entry);
            return this;
        }

        @Override
        public JPool function(LootItemFunction function) {
            this.delegate.m_79078_(() -> function);
            return this;
        }

        @Override
        public JPool function(LootItemFunction.Builder function) {
            this.delegate.m_79078_(function);
            return this;
        }
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JPool> {
        public JsonElement serialize(JPool src, Type typeOfSrc, JsonSerializationContext context) {
            return RuntimeResourcePackImpl.GSON.toJsonTree((Object)src, typeOfSrc);
        }
    }
}

