/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import net.devtech.arrp.annotations.PreferredEnvironment;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@PreferredEnvironment(value=Dist.CLIENT)
public class JPosition
implements Cloneable {
    public float[] rotation;
    public float[] translation;
    public float[] scale;

    public JPosition() {
        this.rotation = new float[3];
        this.translation = new float[3];
        this.scale = new float[3];
    }

    @ApiStatus.AvailableSince(value="0.8.2")
    public JPosition(float[] rotation, float[] translation, float[] scale) {
        this.rotation = rotation;
        this.translation = translation;
        this.scale = scale;
    }

    @Contract(value="_,_,_ -> new")
    public static JPosition ofRotation(float x, float y, float z) {
        return new JPosition(new float[]{x, y, z}, new float[3], new float[3]);
    }

    @Contract(value="_,_,_ -> new")
    public static JPosition ofTranslation(float x, float y, float z) {
        return new JPosition(new float[3], new float[]{x, y, z}, new float[3]);
    }

    @Contract(value="_,_,_ -> new")
    public static JPosition ofScale(float x, float y, float z) {
        return new JPosition(new float[3], new float[3], new float[]{x, y, z});
    }

    @Contract(value="_,_,_ -> this", mutates="this")
    public JPosition rotation(float x, float y, float z) {
        this.rotation[0] = x;
        this.rotation[1] = y;
        this.rotation[2] = z;
        return this;
    }

    @Contract(value="_,_,_ -> this", mutates="this")
    public JPosition translation(float x, float y, float z) {
        this.translation[0] = x;
        this.translation[1] = y;
        this.translation[2] = z;
        return this;
    }

    @Contract(value="_,_,_ -> this", mutates="this")
    public JPosition scale(float x, float y, float z) {
        this.scale[0] = x;
        this.scale[1] = y;
        this.scale[2] = z;
        return this;
    }

    @ApiStatus.AvailableSince(value="0.8.2")
    @Contract(value="_ -> this", mutates="this")
    public JPosition rotation(float[] rotation) {
        this.rotation = rotation;
        return this;
    }

    @ApiStatus.AvailableSince(value="0.8.2")
    @Contract(value="_ -> this", mutates="this")
    public JPosition translation(float[] translation) {
        this.translation = translation;
        return this;
    }

    @ApiStatus.AvailableSince(value="0.8.2")
    @Contract(value="_ -> this", mutates="this")
    public JPosition scale(float[] scale) {
        this.scale = scale;
        return this;
    }

    public JPosition clone() {
        try {
            return (JPosition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

