/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.models;

import com.google.common.collect.ForwardingMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import net.devtech.arrp.annotations.PreferredEnvironment;
import net.devtech.arrp.api.JsonSerializable;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@PreferredEnvironment(value=Dist.CLIENT)
public class JTextures
extends ForwardingMap<String, String>
implements Cloneable,
JsonSerializable {
    private final Map<String, String> textures;

    public JTextures() {
        this(new LinkedHashMap<String, String>());
    }

    public JTextures(Map<String, String> textures) {
        this.textures = textures;
    }

    @Contract(value="_, _ -> new")
    public static JTextures of(String name, String val) {
        return new JTextures().var(name, val);
    }

    @Contract(value="_ -> new")
    public static JTextures of(String ... strings) {
        return new JTextures().vars(strings);
    }

    @Contract(value="_ -> new")
    public static JTextures ofAll(String all) {
        return new JTextures().all(all);
    }

    @Contract(value="_, _, _ -> new")
    public static JTextures ofSides(String top, String side, String bottom) {
        return new JTextures().sides(top, side, bottom);
    }

    @Contract(value="_ -> new")
    public static JTextures ofLayer0(String layer0) {
        return new JTextures().layer0(layer0);
    }

    @NotNull
    public Map<String, String> delegate() {
        return this.textures;
    }

    @Contract(value="_, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures var(String name, String val) {
        this.put(name, val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures vars(String ... strings) {
        for (int i = 0; i < strings.length; i += 2) {
            String name = strings[i];
            String val = strings[i + 1];
            this.put(name, val);
        }
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures all(String all) {
        return this.var("all", all);
    }

    @Contract(value="_, _, _ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures sides(String top, String side, String bottom) {
        return this.var("top", top).var("side", side).var("bottom", bottom);
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures particle(String val) {
        this.put("particle", val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures layer0(String val) {
        this.put("layer0", val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures layer1(String val) {
        this.put("layer1", val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures layer2(String val) {
        this.put("layer2", val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures layer3(String val) {
        this.put("layer3", val);
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JTextures layer4(String val) {
        this.put("layer4", val);
        return this;
    }

    public JTextures clone() {
        try {
            return (JTextures)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        this.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return json;
    }
}

