/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.recipe.JResult;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;

public abstract class JCookingRecipe
extends JRecipe {
    public final JIngredient ingredient;
    public final String result;
    public Float experience;
    public Integer cookingtime;

    protected JCookingRecipe(String type, JIngredient ingredient, String result) {
        super(type);
        this.ingredient = ingredient;
        this.result = result;
    }

    protected JCookingRecipe(String type, JIngredient ingredient, ResourceLocation result) {
        this(type, ingredient, result.toString());
    }

    protected JCookingRecipe(String type, JIngredient ingredient, Item result) {
        this(type, ingredient, Registry.f_122827_.m_7981_((Object)result));
    }

    protected JCookingRecipe(String type, JIngredient ingredient, ItemLike result) {
        this(type, ingredient, Registry.f_122827_.m_7981_((Object)result.m_5456_()));
    }

    public JCookingRecipe(String type, String ingredient, String result) {
        this(type, JIngredient.ofItem(ingredient), result);
    }

    public JCookingRecipe(String type, ResourceLocation ingredient, ResourceLocation result) {
        this(type, JIngredient.ofItem(ingredient), result.toString());
    }

    public JCookingRecipe(String type, ItemLike ingredient, ItemLike result) {
        this(type, JIngredient.ofItem(ingredient), Registry.f_122827_.m_7981_((Object)result.m_5456_()).toString());
    }

    @Deprecated
    protected JCookingRecipe(String type, JIngredient ingredient, JResult result) {
        super(type);
        this.ingredient = ingredient;
        this.result = result.item;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JCookingRecipe experience(float experience) {
        this.experience = Float.valueOf(experience);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JCookingRecipe cookingTime(int cookingtime) {
        this.cookingtime = cookingtime;
        return this;
    }

    @Override
    public JCookingRecipe group(String group) {
        return (JCookingRecipe)super.group(group);
    }

    @Override
    public JCookingRecipe clone() {
        return (JCookingRecipe)super.clone();
    }
}

