/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.tags.IdentifiedTag;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JIngredient
implements Cloneable,
JsonSerializable {
    protected String item;
    protected String tag;
    protected List<JIngredient> ingredients;

    @ApiStatus.Internal
    public JIngredient() {
    }

    protected JIngredient(String item, String tag) {
        this.item = item;
        this.tag = tag;
    }

    @ApiStatus.Internal
    protected JIngredient(List<JIngredient> ingredients) {
        this.ingredients = ingredients;
    }

    @Deprecated
    public static JIngredient ingredient() {
        return new JIngredient();
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JIngredient item(Item item) {
        return this.item(Registry.f_122827_.m_7981_((Object)item).toString());
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JIngredient item(ItemLike itemConvertible) {
        return this.item(itemConvertible.m_5456_());
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JIngredient item(String id) {
        if (this.isDefined()) {
            return this.add(JIngredient.ofItem(id));
        }
        this.item = id;
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JIngredient item(ResourceLocation id) {
        return this.item(id.toString());
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItem(ItemLike itemConvertible) {
        return JIngredient.ofItem(Registry.f_122827_.m_7981_((Object)itemConvertible.m_5456_()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItem(String id) {
        return new JIngredient(id, null);
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItem(ResourceLocation id) {
        return JIngredient.ofItem(id.toString());
    }

    @Contract(value="_ -> this", mutates="this")
    public JIngredient tag(String tagId) {
        if (this.isDefined()) {
            return this.add(JIngredient.ingredient().tag(tagId));
        }
        this.tag = tagId;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    public JIngredient tag(ResourceLocation tagId) {
        return this.tag(tagId.toString());
    }

    @Contract(value="_ -> this", mutates="this")
    public JIngredient tag(IdentifiedTag tag) {
        return this.tag(tag.identifier);
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTag(String tagId) {
        return new JIngredient(null, tagId);
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTag(ResourceLocation tagId) {
        return JIngredient.ofTag(tagId.toString());
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTag(IdentifiedTag tag) {
        return JIngredient.ofTag(tag.identifier);
    }

    @Contract(value="_ -> new")
    public static JIngredient ofMultipleIngredients(List<JIngredient> ingredients) {
        return new JIngredient(ingredients);
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItems(String ... ids) {
        return new JIngredient(Arrays.stream(ids).map(JIngredient::ofItem).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItems(ResourceLocation ... ids) {
        return new JIngredient(Arrays.stream(ids).map(JIngredient::ofItem).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItems(Item ... items) {
        return new JIngredient(Arrays.stream(items).map(item1 -> JIngredient.ofItem(Registry.f_122827_.m_7981_(item1))).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofItems(ItemLike ... itemConvertibles) {
        return new JIngredient(Arrays.stream(itemConvertibles).map(JIngredient::ofItem).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTags(String ... tagIds) {
        return new JIngredient(Arrays.stream(tagIds).map(JIngredient::ofTag).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTags(ResourceLocation ... tagIds) {
        return new JIngredient(Arrays.stream(tagIds).map(JIngredient::ofTag).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient ofTags(IdentifiedTag ... tags) {
        return new JIngredient(Arrays.stream(tags).map(JIngredient::ofTag).collect(Collectors.toList()));
    }

    @Contract(value="_ -> new")
    public static JIngredient delegate(Ingredient delegate) {
        return new Delegate(delegate);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JIngredient add(JIngredient ingredient) {
        if (this.ingredients == null) {
            ArrayList<JIngredient> ingredients = new ArrayList<JIngredient>();
            if (this.isDefined()) {
                ingredients.add(this.clone());
            }
            this.ingredients = ingredients;
        }
        this.ingredients.add(ingredient);
        return this;
    }

    @Contract(pure=true)
    private boolean isDefined() {
        return this.item != null || this.tag != null;
    }

    public JIngredient clone() {
        try {
            return (JIngredient)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        if (this.ingredients != null) {
            return context.serialize(this.ingredients);
        }
        JsonObject object = new JsonObject();
        object.add("item", context.serialize((Object)this.item));
        object.add("tag", context.serialize((Object)this.tag));
        return object;
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JIngredient
    implements JsonSerializable,
    Predicate<ItemStack> {
        public final Ingredient delegate;

        private Delegate(Ingredient delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.delegate.test(itemStack);
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return this.delegate.m_43942_();
        }
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JIngredient> {
        public JsonElement serialize(JIngredient src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize(typeOfSrc, context);
        }
    }
}

