/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.common.collect.ForwardingMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.recipe.JIngredient;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JKeys
extends ForwardingMap<String, JIngredient>
implements Cloneable,
JsonSerializable {
    protected final Map<String, JIngredient> keys;
    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="unsure")
    protected final Map<String, List<JIngredient>> acceptableKeys;

    public JKeys() {
        this.keys = new LinkedHashMap<String, JIngredient>(9, 1.0f);
        this.acceptableKeys = new HashMap<String, List<JIngredient>>();
    }

    public JKeys(Map<String, JIngredient> keys) {
        this.keys = keys;
        this.acceptableKeys = Collections.emptyMap();
    }

    @NotNull
    protected Map<String, JIngredient> delegate() {
        return this.keys;
    }

    @Deprecated
    public static JKeys keys() {
        return new JKeys();
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JKeys key(String key, JIngredient value) {
        this.keys.put(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JKeys key(String key, String value) {
        return this.key(key, JIngredient.ofItem(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JKeys key(String key, ResourceLocation value) {
        return this.key(key, JIngredient.ofItem(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JKeys key(String key, ItemLike value) {
        return this.key(key, JIngredient.ofItem(value));
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this", mutates="this")
    public JKeys key(String key, Item value) {
        return this.key(key, JIngredient.ofItem(Registry.f_122827_.m_7981_((Object)value)));
    }

    public JKeys clone() {
        try {
            return (JKeys)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.keys.forEach((key, ingredient) -> object.add(key, context.serialize(ingredient)));
        this.acceptableKeys.forEach((key, acceptableIngredients) -> object.add(key, context.serialize(acceptableIngredients)));
        return object;
    }

    @Deprecated
    public static class Serializer
    implements JsonSerializer<JKeys> {
        public JsonElement serialize(JKeys src, Type typeOfSrc, JsonSerializationContext context) {
            return src.serialize(typeOfSrc, context);
        }
    }
}

