/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.recipe.JBlastingRecipe;
import net.devtech.arrp.json.recipe.JCampfireRecipe;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.devtech.arrp.json.recipe.JShapelessRecipe;
import net.devtech.arrp.json.recipe.JSmeltingRecipe;
import net.devtech.arrp.json.recipe.JSmithingRecipe;
import net.devtech.arrp.json.recipe.JSmokingRecipe;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.devtech.arrp.json.recipe.JStonecuttingRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class JRecipe
implements Cloneable {
    public final String type;
    public String group;
    public final transient Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft", "recipes/root")).m_138360_(RequirementsStrategy.f_15979_);

    public JRecipe(String type) {
        this.type = type;
    }

    @Deprecated
    @Contract(value="_, _, _ -> new")
    public static JSmithingRecipe smithing(JIngredient base, JIngredient addition, JResult result) {
        return new JSmithingRecipe(base, addition, result);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JStonecuttingRecipe stonecutting(JIngredient ingredient, JStackedResult result) {
        return new JStonecuttingRecipe(ingredient, result);
    }

    @Deprecated
    @Contract(value="_, _, _ -> new")
    public static JShapedRecipe shaped(JPattern pattern, JKeys keys, JResult result) {
        return new JShapedRecipe(result, pattern, keys);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JShapelessRecipe shapeless(JIngredients ingredients, JResult result) {
        return new JShapelessRecipe(result, ingredients);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JBlastingRecipe blasting(JIngredient ingredient, JResult result) {
        return new JBlastingRecipe(ingredient, result);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JSmeltingRecipe smelting(JIngredient ingredient, JResult result) {
        return new JSmeltingRecipe(ingredient, result);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JCampfireRecipe campfire(JIngredient ingredient, JResult result) {
        return new JCampfireRecipe(ingredient, result);
    }

    @Deprecated
    @Contract(value="_, _ -> new")
    public static JSmokingRecipe smoking(JIngredient ingredient, JResult result) {
        return new JSmokingRecipe(ingredient, result);
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this", mutates="this")
    public JRecipe group(String group) {
        this.group = group;
        return this;
    }

    public JRecipe clone() {
        try {
            return (JRecipe)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Contract(value="_ -> new")
    public static JRecipe delegate(FinishedRecipe delegate) {
        return new Delegate(delegate);
    }

    @Contract(value="_ -> new")
    public static JRecipe delegate(RecipeBuilder delegate) {
        AtomicReference jsonProvider = new AtomicReference();
        delegate.m_176498_(jsonProvider::set);
        return JRecipe.delegate((FinishedRecipe)jsonProvider.get());
    }

    @Nullable
    public Advancement.Builder asAdvancement() {
        return this.advancementBuilder;
    }

    @CanIgnoreReturnValue
    @Contract(value="_, _ -> this")
    public JRecipe addInventoryChangedCriterion(String criterionName, ItemLike item) {
        this.advancementBuilder.m_138386_(criterionName, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public JRecipe prepareAdvancement(ResourceLocation recipeId) {
        this.advancementBuilder.m_138354_(new AdvancementRewards.Builder().m_10011_(recipeId)).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId));
        return this;
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JRecipe
    implements JsonSerializable {
        public final FinishedRecipe delegate;

        private Delegate(FinishedRecipe delegate) {
            super(null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return this.delegate.m_125966_();
        }
    }
}

