/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JResultRecipe;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;

public class JShapedRecipe
extends JResultRecipe {
    private static final String TYPE = "minecraft:crafting_shaped";
    protected JPattern pattern;
    protected JKeys key;

    public JShapedRecipe(JResult result) {
        super(TYPE, result);
    }

    public JShapedRecipe(String result) {
        super(TYPE, result);
    }

    public JShapedRecipe(ResourceLocation result) {
        super(TYPE, result);
    }

    public JShapedRecipe(Item result) {
        super(TYPE, (ItemLike)result);
    }

    public JShapedRecipe(ItemLike result) {
        super(TYPE, result);
    }

    public JShapedRecipe(JResult result, JPattern pattern, JKeys keys) {
        super(TYPE, result);
        this.pattern = pattern;
        this.key = keys;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe pattern(JPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Contract(value="_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe pattern(String ... pattern) {
        this.pattern = new JPattern(pattern);
        return this;
    }

    @Contract(value="_,_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe addKey(String key, JIngredient value) {
        if (this.key == null) {
            this.key = new JKeys();
        }
        this.key.key(key, value);
        return this;
    }

    @Contract(value="_,_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe addKey(String key, String value) {
        return this.addKey(key, JIngredient.ofItem(value));
    }

    @Contract(value="_,_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe addKey(String key, ResourceLocation value) {
        return this.addKey(key, JIngredient.ofItem(value));
    }

    @Contract(value="_,_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe addKey(String key, Item value) {
        return this.addKey(key, JIngredient.ofItem(Registry.f_122827_.m_7981_((Object)value)));
    }

    @Contract(value="_,_ -> this", mutates="this")
    @CanIgnoreReturnValue
    public JShapedRecipe addKey(String key, ItemLike value) {
        return this.addKey(key, JIngredient.ofItem(value));
    }

    @Override
    public JShapedRecipe resultCount(int count) {
        return (JShapedRecipe)super.resultCount(count);
    }

    @Override
    public JShapedRecipe group(String group) {
        return (JShapedRecipe)super.group(group);
    }

    @Override
    public JShapedRecipe clone() {
        return (JShapedRecipe)super.clone();
    }
}

