/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.devtech.arrp.api.JsonSerializable;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JResultRecipe;
import net.devtech.arrp.json.tags.IdentifiedTag;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class JSmithingRecipe
extends JResultRecipe {
    public final JIngredient base;
    public final JIngredient addition;

    public JSmithingRecipe(JIngredient base, JIngredient addition, JResult result) {
        super("smithing", result);
        this.base = base;
        this.addition = addition;
    }

    public JSmithingRecipe(ItemLike base, ItemLike addition, ItemLike result) {
        this(JIngredient.ofItem(base), JIngredient.ofItem(addition), new JResult(result));
    }

    public JSmithingRecipe(String base, String addition, String result) {
        this(JIngredient.ofItem(base), JIngredient.ofItem(addition), new JResult(result));
    }

    public JSmithingRecipe(ResourceLocation base, ResourceLocation addition, ResourceLocation result) {
        this(JIngredient.ofItem(base), JIngredient.ofItem(addition), new JResult(result));
    }

    public JSmithingRecipe(IdentifiedTag base, IdentifiedTag addition, ResourceLocation result) {
        this(JIngredient.ofTag(base), JIngredient.ofTag(addition), new JResult(result));
    }

    public JSmithingRecipe(IdentifiedTag base, IdentifiedTag addition, String result) {
        this(JIngredient.ofTag(base), JIngredient.ofTag(addition), new JResult(result));
    }

    public JSmithingRecipe(IdentifiedTag base, IdentifiedTag addition, ItemLike result) {
        this(JIngredient.ofTag(base), JIngredient.ofTag(addition), new JResult(result));
    }

    public static JSmithingRecipe delegate(UpgradeRecipeBuilder.Result delegate) {
        return new Delegate(delegate);
    }

    @Override
    @CanIgnoreReturnValue
    @Contract(value="_ -> this")
    public JSmithingRecipe group(String group) {
        return (JSmithingRecipe)super.group(group);
    }

    @Override
    public JSmithingRecipe clone() {
        return (JSmithingRecipe)super.clone();
    }

    @ApiStatus.Internal
    private static final class Delegate
    extends JSmithingRecipe
    implements JsonSerializable {
        public final UpgradeRecipeBuilder.Result delegate;
        public static final RecipeSerializer<UpgradeRecipe> SERIALIZER = RecipeSerializer.f_44096_;

        private Delegate(UpgradeRecipeBuilder.Result delegate) {
            super((JIngredient)null, null, null);
            this.delegate = delegate;
        }

        @Override
        public JsonElement serialize(Type typeOfSrc, JsonSerializationContext context) {
            return this.delegate.m_125966_();
        }
    }
}

