/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.forge;

import java.nio.file.Path;
import java.util.List;
import net.devtech.arrp.api.RRPEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import pers.solid.brrp.PlatformBridge;

@ApiStatus.AvailableSince(value="0.8.1")
public class PlatformBridgeImpl
extends PlatformBridge {
    public static final PlatformBridgeImpl INSTANCE = new PlatformBridgeImpl();

    private PlatformBridgeImpl() {
    }

    @Override
    public void postBefore(PackType type, List<PackResources> packs) {
        RRPEvent.BeforeVanilla beforeVanilla = new RRPEvent.BeforeVanilla(packs, type);
        if (ModLoader.isLoadingStateValid()) {
            ModLoader.get().postEvent((Event)beforeVanilla);
        }
    }

    @Override
    public void postAfter(PackType type, List<PackResources> packs) {
        RRPEvent.AfterVanilla afterVanilla = new RRPEvent.AfterVanilla(packs, type);
        if (ModLoader.isLoadingStateValid()) {
            ModLoader.get().postEvent((Event)afterVanilla);
        }
    }

    @Override
    public Path getConfigDir() {
        return Path.of(FMLConfig.defaultConfigPath(), new String[0]);
    }

    @Override
    public boolean isClientEnvironment() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    @Override
    public void registerBlock(ResourceLocation identifier, Block block) {
        ForgeRegistries.BLOCKS.register(identifier, (Object)block);
    }

    @Override
    public void registerItem(ResourceLocation identifier, Item item) {
        ForgeRegistries.ITEMS.register(identifier, (Object)item);
    }

    public static PlatformBridge getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }
}

