/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Collection;
import java.util.List;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.criterion.BoughtFromTradingStationCriterion;
import juuxel.adorn.lib.AdornGameRules;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.NbtExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u000f\u0012\u0006\u0010@\u001a\u00020?\u00a2\u0006\u0004\bA\u0010BJ#\u0010\b\u001a\u00020\u00072\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ7\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010$\u001a\n #*\u0004\u0018\u00010\"0\"2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\n #*\u0004\u0018\u00010&0&2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b'\u0010(J7\u0010)\u001a\n #*\u0004\u0018\u00010\"0\"2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b)\u0010%J\u0017\u0010+\u001a\u00020\u00052\u0006\u0010!\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J;\u00100\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b0\u00101J7\u00104\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b4\u00105JA\u0010=\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020-2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u00107\u001a\u0002062\u0006\u00109\u001a\u0002082\b\u0010;\u001a\u0004\u0018\u00010:H\u0016\u00a2\u0006\u0004\b=\u0010>\u00a8\u0006D"}, d2={"Ljuuxel/adorn/block/TradingStationBlock;", "Ljuuxel/adorn/block/VisibleBlockWithEntity;", "Ljuuxel/adorn/block/BlockWithDescription;", "Lnet/minecraft/state/StateManager$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/level/BlockGetter;", "world", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "options", "appendTooltip", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/BlockGetter;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "state", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "type", "", "canPathfindThrough", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/pathfinder/PathComputationType;)Z", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "createBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getCollisionShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/material/FluidState;", "getFluidState", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/material/FluidState;", "getOutlineShape", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "onPlaced", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V", "newState", "moved", "onStateReplaced", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/phys/BlockHitResult;", "hitResult", "Lnet/minecraft/world/InteractionResult;", "onUse", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/block/AbstractBlock$Settings;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Companion", "Adorn"})
public final class TradingStationBlock
extends VisibleBlockWithEntity
implements BlockWithDescription {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    @NotNull
    private static final String OWNER_DESCRIPTION = "block.adorn.trading_station.description.owner";
    private static final VoxelShape LEG_SHAPE;
    private static final VoxelShape OUTLINE_SHAPE;
    private static final VoxelShape COLLISION_SHAPE;

    public TradingStationBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.m_7926_(builder);
        Property[] propertyArray = new Property[]{(Property)WATERLOGGED};
        builder.m_61104_(propertyArray);
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(Intrinsics.areEqual((Object)context.m_43725_().m_6425_(context.m_8083_()).m_76152_(), (Object)Fluids.f_76193_)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"defaultState.with(WATERL\u2026s).fluid == Fluids.WATER)");
        return (BlockState)object;
    }

    public FluidState m_5888_(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.m_61143_((Property)WATERLOGGED);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"state[WATERLOGGED]");
        return (Boolean)comparable != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (entity instanceof Player) {
            BlockEntity blockEntity = world.m_7702_(pos);
            TradingStationBlockEntity tradingStationBlockEntity = blockEntity instanceof TradingStationBlockEntity ? (TradingStationBlockEntity)blockEntity : null;
            if (tradingStationBlockEntity == null) {
                return;
            }
            TradingStationBlockEntity be = tradingStationBlockEntity;
            be.setOwner((Player)entity);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @Nullable BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof TradingStationBlockEntity) {
            if (((TradingStationBlockEntity)be).getOwner() == null) {
                ((TradingStationBlockEntity)be).setOwner(player);
            }
            if (!((TradingStationBlockEntity)be).isOwner(player)) {
                Trade trade;
                ItemStack handStack = player.m_21120_(hand);
                boolean validPayment = handStack.m_41726_((trade = ((TradingStationBlockEntity)be).getTrade()).getPrice()) && handStack.m_41613_() >= trade.getPrice().m_41613_() && Intrinsics.areEqual((Object)handStack.m_41783_(), (Object)trade.getPrice().m_41783_());
                boolean canInsertPayment = ((TradingStationBlockEntity)be).getStorage().canInsert(trade.getPrice());
                if (trade.isEmpty()) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.adorn.trading_station.empty_trade"), true);
                } else if (!((TradingStationBlockEntity)be).isStorageStocked()) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.adorn.trading_station.storage_not_stocked"), true);
                } else if (!canInsertPayment) {
                    player.m_5661_((Component)Component.m_237115_((String)"block.adorn.trading_station.storage_full"), true);
                } else if (validPayment) {
                    handStack.m_41774_(trade.getPrice().m_41613_());
                    ItemStack soldItem = trade.getSelling().m_41777_();
                    player.m_36356_(soldItem);
                    ((TradingStationBlockEntity)be).getStorage().tryExtract(trade.getSelling());
                    ((TradingStationBlockEntity)be).getStorage().tryInsert(trade.getPrice());
                    player.m_36220_(AdornStats.INSTANCE.getINTERACT_WITH_TRADING_STATION());
                    if (player instanceof ServerPlayer) {
                        BoughtFromTradingStationCriterion boughtFromTradingStationCriterion = AdornCriteria.INSTANCE.getBOUGHT_FROM_TRADING_STATION();
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        Intrinsics.checkNotNullExpressionValue((Object)soldItem, (String)"soldItem");
                        boughtFromTradingStationCriterion.trigger(serverPlayer, soldItem);
                    }
                }
            } else {
                player.m_5893_((MenuProvider)be);
                player.m_36220_(AdornStats.INSTANCE.getINTERACT_WITH_TRADING_STATION());
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moved) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TradingStationBlockEntity) {
                if (!world.m_46469_().m_46207_(AdornGameRules.INSTANCE.getDROP_LOCKED_TRADING_STATIONS())) {
                    Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((TradingStationBlockEntity)entity).getStorage());
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return OUTLINE_SHAPE;
    }

    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return COLLISION_SHAPE;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return AdornBlockEntities.INSTANCE.getTRADING_STATION().m_155264_(pos, state);
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter world, @NotNull List<Component> tooltip, @NotNull TooltipFlag options) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            super.m_5871_(stack, world, tooltip, options);
            CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
            if (compoundTag == null) break block2;
            CompoundTag nbt = compoundTag;
            boolean bl = false;
            if (nbt.m_128441_("TradingOwner")) {
                Component component = NbtExtensionsKt.getText(nbt, "TradingOwnerName");
                if (component == null) {
                    component = TradingStationBlockEntity.Companion.getUNKNOWN_OWNER();
                }
                Component owner = component;
                Collection collection = tooltip;
                Object[] objectArray = new Object[]{owner.m_6881_().m_130940_(ChatFormatting.WHITE)};
                collection.add(Component.m_237110_((String)OWNER_DESCRIPTION, (Object[])objectArray).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    static {
        VoxelShape[] voxelShapeArray = new VoxelShape[]{BaseEntityBlock.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), BaseEntityBlock.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), BaseEntityBlock.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0)};
        LEG_SHAPE = Shapes.m_83124_((VoxelShape)BaseEntityBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), (VoxelShape[])voxelShapeArray);
        OUTLINE_SHAPE = Shapes.m_83110_((VoxelShape)BaseEntityBlock.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)LEG_SHAPE);
        COLLISION_SHAPE = Shapes.m_83110_((VoxelShape)BaseEntityBlock.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)LEG_SHAPE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005R\u001c\u0010\u0006\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0005R\u001c\u0010\u0007\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0005R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001f\u0010\f\u001a\n \u0003*\u0004\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Ljuuxel/adorn/block/TradingStationBlock$Companion;", "", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "COLLISION_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "LEG_SHAPE", "OUTLINE_SHAPE", "", "OWNER_DESCRIPTION", "Ljava/lang/String;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

