/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import java.util.UUID;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.entity.TradingStation;
import juuxel.adorn.menu.TradingStationMenu;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.ExtensionsKt;
import juuxel.adorn.util.InventoryComponent;
import juuxel.adorn.util.NbtExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001AB\u0017\u0012\u0006\u0010<\u001a\u00020;\u0012\u0006\u0010>\u001a\u00020=\u00a2\u0006\u0004\b?\u0010@J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b#\u0010\u001aR$\u0010%\u001a\u0004\u0018\u00010$8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b\u001b\u0010)R\"\u0010+\u001a\u00020*8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00102\u001a\u0002018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u001a\u00107\u001a\u0002068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\u00a8\u0006B"}, d2={"Ljuuxel/adorn/block/entity/TradingStationBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "Ljuuxel/adorn/block/entity/TradingStation;", "", "syncId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInv", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "getDisplayName", "()Lnet/minecraft/network/chat/MutableComponent;", "", "isOwner", "(Lnet/minecraft/world/entity/player/Player;)Z", "isStorageStocked", "()Z", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "", "readNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "setOwner", "(Lnet/minecraft/world/entity/player/Player;)V", "toInitialChunkDataNbt", "()Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "toUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "writeNbt", "Ljava/util/UUID;", "owner", "Ljava/util/UUID;", "getOwner", "()Ljava/util/UUID;", "(Ljava/util/UUID;)V", "Lnet/minecraft/network/chat/Component;", "ownerName", "Lnet/minecraft/network/chat/Component;", "getOwnerName", "()Lnet/minecraft/network/chat/Component;", "setOwnerName", "(Lnet/minecraft/network/chat/Component;)V", "Ljuuxel/adorn/util/InventoryComponent;", "storage", "Ljuuxel/adorn/util/InventoryComponent;", "getStorage", "()Ljuuxel/adorn/util/InventoryComponent;", "Ljuuxel/adorn/trading/Trade;", "trade", "Ljuuxel/adorn/trading/Trade;", "getTrade", "()Ljuuxel/adorn/trading/Trade;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "Adorn"})
public final class TradingStationBlockEntity
extends BlockEntity
implements MenuProvider,
TradingStation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID owner;
    @NotNull
    private Component ownerName;
    @NotNull
    private final Trade trade;
    @NotNull
    private final InventoryComponent storage;
    public static final int STORAGE_SIZE = 12;
    @NotNull
    public static final String NBT_TRADING_OWNER = "TradingOwner";
    @NotNull
    public static final String NBT_TRADING_OWNER_NAME = "TradingOwnerName";
    @NotNull
    public static final String NBT_TRADE = "Trade";
    @NotNull
    public static final String NBT_STORAGE = "Storage";
    @NotNull
    private static final Component UNKNOWN_OWNER;

    public TradingStationBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(AdornBlockEntities.INSTANCE.getTRADING_STATION(), pos, state);
        this.ownerName = UNKNOWN_OWNER;
        this.trade = Trade.Companion.empty();
        this.storage = new InventoryComponent(12);
        this.getTrade().addListener(arg_0 -> TradingStationBlockEntity._init_$lambda-0(this, arg_0));
        this.getStorage().addListener(arg_0 -> TradingStationBlockEntity._init_$lambda-1(this, arg_0));
    }

    @Nullable
    public final UUID getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable UUID uUID) {
        this.owner = uUID;
    }

    @Override
    @NotNull
    public Component getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
        this.ownerName = component;
    }

    @Override
    @NotNull
    public Trade getTrade() {
        return this.trade;
    }

    @Override
    @NotNull
    public InventoryComponent getStorage() {
        return this.storage;
    }

    public final void setOwner(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.owner = player.m_36316_().getId();
        MutableComponent mutableComponent = Component.m_237113_((String)player.m_36316_().getName());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(player.gameProfile.name)");
        this.setOwnerName((Component)mutableComponent);
        this.m_6596_();
    }

    public final boolean isStorageStocked() {
        return this.getStorage().getAmountWithNbt(this.getTrade().getSelling()) >= this.getTrade().getSelling().m_41613_();
    }

    public final boolean isOwner(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Intrinsics.areEqual((Object)player.m_36316_().getId(), (Object)this.owner);
    }

    @NotNull
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory playerInv, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInv, (String)"playerInv");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new TradingStationMenu(syncId, (Container)playerInv, ExtensionsKt.menuContextOf(this));
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_142466_(nbt);
        if (nbt.m_128403_(NBT_TRADING_OWNER)) {
            this.owner = nbt.m_128342_(NBT_TRADING_OWNER);
        } else if (NbtExtensionsKt.containsOldUuid(nbt, NBT_TRADING_OWNER)) {
            this.owner = NbtExtensionsKt.getOldUuid(nbt, NBT_TRADING_OWNER);
        }
        if ((component = NbtExtensionsKt.getText(nbt, NBT_TRADING_OWNER_NAME)) == null) {
            component = UNKNOWN_OWNER;
        }
        this.setOwnerName(component);
        Trade trade = this.getTrade();
        CompoundTag compoundTag = nbt.m_128469_(NBT_TRADE);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"nbt.getCompound(NBT_TRADE)");
        trade.readNbt(compoundTag);
        InventoryComponent inventoryComponent = this.getStorage();
        CompoundTag compoundTag2 = nbt.m_128469_(NBT_STORAGE);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"nbt.getCompound(NBT_STORAGE)");
        inventoryComponent.readNbt(compoundTag2);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.m_183515_(nbt);
        Unit $this$writeNbt_u24lambda_u2d2 = unit = Unit.INSTANCE;
        boolean bl = false;
        if (this.owner != null) {
            nbt.m_128362_(NBT_TRADING_OWNER, this.owner);
        }
        NbtExtensionsKt.putText(nbt, NBT_TRADING_OWNER_NAME, this.getOwnerName());
        nbt.m_128365_(NBT_TRADE, (Tag)this.getTrade().writeNbt(new CompoundTag()));
        nbt.m_128365_(NBT_STORAGE, (Tag)this.getStorage().writeNbt(new CompoundTag()));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(this)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = this.m_187482_();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"createNbt()");
        return compoundTag;
    }

    private static final void _init_$lambda-0(TradingStationBlockEntity this$0, Trade it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.m_6596_();
    }

    private static final void _init_$lambda-1(TradingStationBlockEntity this$0, Container it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.m_6596_();
    }

    static {
        MutableComponent mutableComponent = Component.m_237113_((String)"???");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(\"???\")");
        UNKNOWN_OWNER = (Component)mutableComponent;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Ljuuxel/adorn/block/entity/TradingStationBlockEntity$Companion;", "", "", "NBT_STORAGE", "Ljava/lang/String;", "NBT_TRADE", "NBT_TRADING_OWNER", "NBT_TRADING_OWNER_NAME", "", "STORAGE_SIZE", "I", "Lnet/minecraft/network/chat/Component;", "UNKNOWN_OWNER", "Lnet/minecraft/network/chat/Component;", "getUNKNOWN_OWNER", "()Lnet/minecraft/network/chat/Component;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component getUNKNOWN_OWNER() {
            return UNKNOWN_OWNER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

