/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import juuxel.adorn.config.Config;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.platform.forge.ConfigManagerImpl;
import juuxel.adorn.relocated.jankson.Jankson;
import juuxel.adorn.relocated.jankson.JsonElement;
import juuxel.adorn.relocated.jankson.JsonObject;
import juuxel.adorn.relocated.jankson.JsonPrimitive;
import juuxel.adorn.relocated.jankson.api.DeserializationException;
import juuxel.adorn.relocated.jankson.api.Marshaller;
import juuxel.adorn.util.InlineServices;
import juuxel.adorn.util.LoggingKt;
import juuxel.adorn.util.ServicesKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b'\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\u0004J\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\f\u0010\u000eR\u001b\u0010\u0007\u001a\u00020\r8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0019\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0015R\u0016\u0010\u001a\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001f"}, d2={"Ljuuxel/adorn/config/ConfigManager;", "", "", "finalize", "()V", "init", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "config", "defaults", "", "isMissingKeys", "(Ljuuxel/adorn/relocated/jankson/JsonObject;Ljuuxel/adorn/relocated/jankson/JsonObject;)Z", "save", "Ljuuxel/adorn/config/Config;", "(Ljuuxel/adorn/config/Config;)V", "config$delegate", "Lkotlin/Lazy;", "getConfig", "()Ljuuxel/adorn/config/Config;", "Ljava/nio/file/Path;", "getConfigDirectory", "()Ljava/nio/file/Path;", "configDirectory", "configPath$delegate", "getConfigPath", "configPath", "finalized", "Z", "saveScheduled", "<init>", "Companion", "Adorn"})
@InlineServices
public abstract class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configPath$delegate = LazyKt.lazy(() -> ConfigManager.configPath_delegate$lambda-0(this));
    private boolean saveScheduled;
    private boolean finalized;
    @NotNull
    private final Lazy config$delegate = LazyKt.lazy(() -> ConfigManager.config_delegate$lambda-1(this));
    @NotNull
    private static final Lazy<ConfigManager> INSTANCE$delegate = LazyKt.lazy(ConfigManager::INSTANCE_delegate$lambda-2);
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(FluidUnit.class, ConfigManager::JANKSON$lambda-3).registerDeserializer(JsonPrimitive.class, FluidUnit.class, ConfigManager::JANKSON$lambda-4).build();
    @NotNull
    private static final JsonObject DEFAULT;
    @NotNull
    private static final Logger LOGGER;

    @NotNull
    protected abstract Path getConfigDirectory();

    private final Path getConfigPath() {
        Lazy lazy = this.configPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-configPath>(...)");
        return (Path)object;
    }

    @JvmName(name="getConfig")
    @NotNull
    public final Config getConfig() {
        Lazy lazy = this.config$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-config>(...)");
        return (Config)object;
    }

    public final void init() {
        this.getConfig();
    }

    public final void save() {
        if (this.finalized) {
            this.save(this.getConfig());
        } else {
            this.saveScheduled = true;
        }
    }

    public final void finalize() {
        this.finalized = true;
        if (this.saveScheduled) {
            this.save();
        }
    }

    private final void save(Config config) {
        Path path = this.getConfigPath();
        String string = JANKSON.toJson(config).toJson(true, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JANKSON.toJson(config).toJson(true, true)");
        Files.write(path, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)string), new OpenOption[0]);
    }

    private final boolean isMissingKeys(JsonObject config, JsonObject defaults) {
        for (Map.Entry entry : ((Map)defaults).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value2 = (JsonElement)entry.getValue();
            if (!config.containsKey(key)) {
                return true;
            }
            if (!(value2 instanceof JsonObject)) continue;
            JsonObject jsonObject = config.get(JsonObject.class, key);
            if (jsonObject == null) {
                return true;
            }
            if (!this.isMissingKeys(jsonObject, (JsonObject)value2)) continue;
            return true;
        }
        return false;
    }

    private static final Path configPath_delegate$lambda-0(ConfigManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getConfigDirectory().resolve("Adorn.json5");
    }

    private static final Config config_delegate$lambda-1(ConfigManager this$0) {
        Config config;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Files.notExists(this$0.getConfigPath(), new LinkOption[0])) {
            this$0.save(new Config());
        }
        try {
            Config config2;
            List<String> list = Files.readAllLines(this$0.getConfigPath());
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(configPath)");
            JsonObject jsonObject = JANKSON.load(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"JANKSON.load(Files.readA\u2026Path).joinToString(\"\\n\"))");
            JsonObject obj = jsonObject;
            try {
                config2 = JANKSON.fromJsonCarefully(obj, Config.class);
            }
            catch (DeserializationException e) {
                Config config3 = JANKSON.fromJson(obj, Config.class);
                if (config3 == null) {
                    throw e;
                }
                config2 = config3;
            }
            Config config4 = config2;
            if (this$0.isMissingKeys(obj, DEFAULT)) {
                LOGGER.info("[Adorn] Upgrading config...");
                Intrinsics.checkNotNullExpressionValue((Object)config4, (String)"config");
                this$0.save(config4);
            }
            config = config4;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Adorn config file!", e);
        }
        return config;
    }

    private static final ConfigManager INSTANCE_delegate$lambda-2() {
        boolean $i$f$loadService = false;
        Optional<ConfigManagerImpl> optional = Optional.of(new ConfigManagerImpl());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"load(T::class.java).findFirst()");
        return ServicesKt.unwrapService(optional, ConfigManager.class);
    }

    private static final JsonElement JANKSON$lambda-3(FluidUnit unit, Marshaller marshaller) {
        return new JsonPrimitive(unit.getId());
    }

    private static final FluidUnit JANKSON$lambda-4(JsonPrimitive json, Marshaller marshaller) {
        String string = json.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.asString()");
        FluidUnit fluidUnit = FluidUnit.Companion.byId(string);
        if (fluidUnit == null) {
            fluidUnit = FluidUnit.LITRE;
        }
        return fluidUnit;
    }

    static {
        JsonElement jsonElement = JANKSON.toJson(new Config());
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type blue.endless.jankson.JsonObject");
        DEFAULT = (JsonObject)jsonElement;
        LOGGER = LoggingKt.logger();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ljuuxel/adorn/config/ConfigManager$Companion;", "", "Ljuuxel/adorn/config/Config;", "config", "()Ljuuxel/adorn/config/Config;", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "DEFAULT", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "Ljuuxel/adorn/config/ConfigManager;", "INSTANCE$delegate", "Lkotlin/Lazy;", "getINSTANCE", "()Ljuuxel/adorn/config/ConfigManager;", "INSTANCE", "Ljuuxel/adorn/relocated/jankson/Jankson;", "kotlin.jvm.PlatformType", "JANKSON", "Ljuuxel/adorn/relocated/jankson/Jankson;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigManager getINSTANCE() {
            Lazy lazy = INSTANCE$delegate;
            return (ConfigManager)lazy.getValue();
        }

        @NotNull
        public final Config config() {
            return this.getINSTANCE().getConfig();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

