/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.annotation;

import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotatedConfigBuilder {
    public static <T extends ConfigCore> void serialize(AbstractConfigBuilder builder, ConfigDataHolderImpl<?> context, @NotNull T target) {
        AnnotatedConfigBuilder.serialize(builder, context, target.getClass(), target);
    }

    public static <T extends ConfigCore> void serialize(AbstractConfigBuilder builder, ConfigDataHolderImpl<?> context, Class<? extends T> target) {
        AnnotatedConfigBuilder.serialize(builder, context, target, null);
    }

    public static <T extends ConfigCore> void serialize(AbstractConfigBuilder builder, ConfigDataHolderImpl<?> context, Class<? extends T> target, @Nullable T instance) {
        if (instance != null) {
            context.accept(instance::afterConfigReload);
        }
        Map<List<String>, Collection<Field>> pathToFields = AnnotatedConfigBuilder.setupFields(target);
        for (Map.Entry<List<String>, Collection<Field>> entry : pathToFields.entrySet()) {
            List<String> path = entry.getKey();
            if (!path.isEmpty()) {
                for (String category : path) {
                    builder.push(category);
                }
            }
            for (Field field : entry.getValue()) {
                field.setAccessible(true);
                boolean isStatic = Modifier.isStatic(field.getModifiers());
                if (!isStatic) {
                    Objects.requireNonNull(instance, "Null instance for non-static field");
                }
                AnnotatedConfigBuilder.buildConfig(builder, context, isStatic ? null : instance, field, field.getDeclaredAnnotation(Config.class));
            }
            if (path.isEmpty()) continue;
            builder.pop(path.size());
        }
        if (instance != null) {
            instance.addToBuilder(builder, context);
        }
    }

    private static Map<List<String>, Collection<Field>> setupFields(Class<?> target) {
        HashMultimap pathToField = HashMultimap.create();
        for (Field field : AnnotatedConfigBuilder.getAllFields(target)) {
            Config annotation = field.getDeclaredAnnotation(Config.class);
            if (annotation == null) continue;
            pathToField.put((Object)Lists.newArrayList((Object[])annotation.category()), (Object)field);
        }
        return pathToField.asMap();
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        LinkedList<Field> list = new LinkedList<Field>();
        while (clazz != Object.class) {
            list.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    private static void buildConfig(AbstractConfigBuilder builder, ConfigDataHolderImpl<?> context, @Nullable Object instance, Field field, Config annotation) {
        Object defaultValue;
        String name = annotation.name();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
        }
        Class<?> type = field.getType();
        try {
            defaultValue = field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Object[] description = annotation.description();
        if (description.length != 0) {
            builder.comment((String[])description);
        }
        if (ConfigCore.class.isAssignableFrom(type)) {
            builder.push(name);
            AnnotatedConfigBuilder.serialize(builder, context, type, (ConfigCore)defaultValue);
            builder.pop();
            return;
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new RuntimeException("Field may not be final");
        }
        if (annotation.worldRestart()) {
            builder.worldRestart();
        }
        if (type == Boolean.TYPE) {
            AnnotatedConfigBuilder.addCallback(context, builder.define(name, (boolean)((Boolean)defaultValue)), field, instance);
        } else if (type == Integer.TYPE) {
            int min = Integer.MIN_VALUE;
            int max = Integer.MAX_VALUE;
            Config.IntRange intRange = field.getDeclaredAnnotation(Config.IntRange.class);
            if (intRange != null) {
                min = intRange.min();
                max = intRange.max();
            }
            AnnotatedConfigBuilder.addCallback(context, builder.defineInRange(name, (int)((Integer)defaultValue), min, max), field, instance);
        } else if (type == Long.TYPE) {
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            Config.LongRange longRange = field.getDeclaredAnnotation(Config.LongRange.class);
            if (longRange != null) {
                min = longRange.min();
                max = longRange.max();
            }
            AnnotatedConfigBuilder.addCallback(context, builder.defineInRange(name, (long)((Long)defaultValue), min, max), field, instance);
        } else if (type == Double.TYPE) {
            double min = Double.MIN_VALUE;
            double max = Double.MAX_VALUE;
            Config.DoubleRange doubleRange = field.getDeclaredAnnotation(Config.DoubleRange.class);
            if (doubleRange != null) {
                min = doubleRange.min();
                max = doubleRange.max();
            }
            AnnotatedConfigBuilder.addCallback(context, builder.defineInRange(name, (double)((Double)defaultValue), min, max), field, instance);
        } else if (type == String.class) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                builder.comment((String[])ObjectArrays.concat((Object[])description, (Object)String.format("Allowed Values: %s", String.join((CharSequence)", ", allowedValues.values()))));
                AnnotatedConfigBuilder.addCallback(context, builder.define(name, (String)defaultValue, o -> AnnotatedConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                AnnotatedConfigBuilder.addCallback(context, builder.define(name, (String)defaultValue), field, instance);
            }
        } else if (type.isEnum()) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                AnnotatedConfigBuilder.addCallback(context, builder.defineEnum(name, (Enum)defaultValue, o -> AnnotatedConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                AnnotatedConfigBuilder.addCallback(context, builder.defineEnum(name, (Enum)defaultValue), field, instance);
            }
        } else if (type == List.class) {
            Config.AllowedValues allowedValues = field.getDeclaredAnnotation(Config.AllowedValues.class);
            if (allowedValues != null && allowedValues.values().length != 0) {
                builder.comment((String[])ObjectArrays.concat((Object[])description, (Object)String.format("Allowed Values: %s", String.join((CharSequence)", ", allowedValues.values()))));
                AnnotatedConfigBuilder.addCallback(context, builder.defineList(name, (List)defaultValue, o -> AnnotatedConfigBuilder.testAllowedValues(allowedValues.values(), o)), field, instance);
            } else {
                AnnotatedConfigBuilder.addCallback(context, builder.defineList(name, (List)defaultValue, o -> true), field, instance);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unsupported config value type: %s", type));
        }
    }

    private static boolean testAllowedValues(String[] allowedValues, @Nullable Object o) {
        if (o != null) {
            String value = o instanceof Enum ? ((Enum)o).name() : o.toString();
            for (String allowedValue : allowedValues) {
                if (!allowedValue.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addCallback(ConfigDataHolderImpl<?> context, Supplier<?> configValue, Field field, @Nullable Object instance) {
        context.accept(configValue, v -> {
            try {
                field.set(instance, configValue.get());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

