/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.init;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.core.ModLoader;
import fuzs.puzzleslib.init.ForgeRegistryReference;
import fuzs.puzzleslib.init.RegistryManager;
import fuzs.puzzleslib.init.RegistryReference;
import fuzs.puzzleslib.init.builder.ExtendedModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModBlockEntityTypeBuilder;
import fuzs.puzzleslib.init.builder.ModMenuSupplier;
import fuzs.puzzleslib.init.builder.ModPoiTypeBuilder;
import fuzs.puzzleslib.util.PuzzlesUtilForge;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryManager
implements RegistryManager {
    private static final Map<String, ForgeRegistryManager> MOD_TO_REGISTRY = Maps.newConcurrentMap();
    private final String namespace;
    private final IEventBus modEventBus;
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> deferredRegisters = Maps.newIdentityHashMap();
    @Nullable
    private Set<ModLoader> allowedModLoaders;

    private ForgeRegistryManager(String modId) {
        this.namespace = modId;
        this.modEventBus = PuzzlesUtilForge.findModEventBus(modId);
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public RegistryManager whenOn(ModLoader ... allowedModLoaders) {
        if (allowedModLoaders.length == 0) {
            throw new IllegalArgumentException("Must provide at least one mod loader to register on");
        }
        this.allowedModLoaders = ImmutableSet.copyOf((Object[])allowedModLoaders);
        return this;
    }

    @Override
    public <T> RegistryReference<T> register(ResourceKey<? extends Registry<? super T>> registryKey, String path, Supplier<T> supplier) {
        Set<ModLoader> modLoaders = this.allowedModLoaders;
        this.allowedModLoaders = null;
        if (modLoaders != null && !modLoaders.contains((Object)ModLoader.FORGE)) {
            return this.placeholder(registryKey, path);
        }
        DeferredRegister register = this.deferredRegisters.computeIfAbsent(registryKey, key -> {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)registryKey, (String)this.namespace);
            deferredRegister.register(this.modEventBus);
            return deferredRegister;
        });
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("Can't register object without name");
        }
        RegistryObject registryObject = register.register(path, supplier);
        return new ForgeRegistryReference(registryObject, registryKey);
    }

    @Override
    public <T extends BlockEntity> RegistryReference<BlockEntityType<T>> registerBlockEntityTypeBuilder(String path, Supplier<ModBlockEntityTypeBuilder<T>> entry) {
        return this.registerBlockEntityType(path, () -> {
            ModBlockEntityTypeBuilder builder = (ModBlockEntityTypeBuilder)entry.get();
            return BlockEntityType.Builder.m_155273_(builder.factory()::create, (Block[])builder.blocks()).m_58966_(null);
        });
    }

    @Override
    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerMenuTypeSupplier(String path, Supplier<ModMenuSupplier<T>> entry) {
        return this.registerMenuType(path, () -> new MenuType(((ModMenuSupplier)entry.get())::create));
    }

    @Override
    public <T extends AbstractContainerMenu> RegistryReference<MenuType<T>> registerExtendedMenuTypeSupplier(String path, Supplier<ExtendedModMenuSupplier<T>> entry) {
        return this.registerMenuType(path, () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)(arg_0, arg_1, arg_2) -> ForgeRegistryManager.lambda$registerExtendedMenuTypeSupplier$3((Supplier)entry, arg_0, arg_1, arg_2))));
    }

    @Override
    public RegistryReference<PoiType> registerPoiTypeBuilder(String path, Supplier<ModPoiTypeBuilder> entry) {
        return this.register(Registry.f_122810_, path, () -> {
            ModPoiTypeBuilder builder = (ModPoiTypeBuilder)entry.get();
            return new PoiType((Set)ImmutableSet.copyOf(builder.blocks()), builder.ticketCount(), builder.searchDistance());
        });
    }

    public static synchronized RegistryManager of(String modId) {
        return MOD_TO_REGISTRY.computeIfAbsent(modId, ForgeRegistryManager::new);
    }

    private static /* synthetic */ AbstractContainerMenu lambda$registerExtendedMenuTypeSupplier$3(Supplier entry, int containerId, Inventory inventory, FriendlyByteBuf data) {
        return ((ExtendedModMenuSupplier)entry.get()).create(containerId, inventory, data);
    }
}

