/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer;

import com.google.auto.service.AutoService;
import com.matyrobbrt.okzoomer.api.MouseModifier;
import com.matyrobbrt.okzoomer.api.OkZoomerAPI;
import com.matyrobbrt.okzoomer.api.TransitionMode;
import com.matyrobbrt.okzoomer.api.ZoomInstance;
import com.matyrobbrt.okzoomer.api.ZoomOverlay;
import com.matyrobbrt.okzoomer.api.transitions.InstantTransitionMode;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@AutoService(value={OkZoomerAPI.class})
public class APIImpl
implements OkZoomerAPI {
    private static final Set<ZoomInstance> zoomInstances = new ReferenceArraySet();
    private static boolean iterateZoom;
    private static boolean iterateTransitions;
    private static boolean iterateModifiers;
    private static boolean iterateOverlays;

    @Override
    public ZoomInstance registerZoom(ZoomInstance instance) {
        for (ZoomInstance zoomInstance : zoomInstances) {
            if (!zoomInstance.getInstanceId().equals((Object)instance.getInstanceId())) continue;
            throw new RuntimeException("Multiple zoom instances with the ID " + zoomInstance.getInstanceId() + " were found!");
        }
        return zoomInstances.add(instance) ? instance : null;
    }

    @Override
    public ZoomInstance createZoomInstance(ResourceLocation instanceId, float defaultZoomDivisor, TransitionMode transition, @Nullable MouseModifier modifier, @Nullable ZoomOverlay overlay) {
        return new InstanceImpl(instanceId, defaultZoomDivisor, transition, modifier, overlay);
    }

    public static Set<ZoomInstance> getZoomInstances() {
        return zoomInstances;
    }

    public static boolean shouldIterateZoom() {
        return iterateZoom;
    }

    @ApiStatus.Internal
    public static void setIterateZoom(boolean iterateZoom) {
        APIImpl.iterateZoom = iterateZoom;
    }

    public static boolean shouldIterateTransitions() {
        return iterateTransitions;
    }

    @ApiStatus.Internal
    public static void setIterateTransitions(boolean iterateTransitions) {
        APIImpl.iterateTransitions = iterateTransitions;
    }

    public static boolean shouldIterateModifiers() {
        return iterateModifiers;
    }

    @ApiStatus.Internal
    public static void setIterateModifiers(boolean iterateModifiers) {
        APIImpl.iterateModifiers = iterateModifiers;
    }

    public static boolean shouldIterateOverlays() {
        return iterateOverlays;
    }

    @ApiStatus.Internal
    public static void setIterateOverlays(boolean iterateOverlays) {
        APIImpl.iterateOverlays = iterateOverlays;
    }

    private static final class InstanceImpl
    implements ZoomInstance {
        private final ResourceLocation instanceId;
        private boolean zoom;
        private double defaultZoomDivisor;
        private double zoomDivisor;
        private TransitionMode transition;
        private MouseModifier modifier;
        private ZoomOverlay overlay;

        public InstanceImpl(ResourceLocation instanceId, float defaultZoomDivisor, TransitionMode transition, @Nullable MouseModifier modifier, @Nullable ZoomOverlay overlay) {
            this.instanceId = instanceId;
            this.zoom = false;
            this.zoomDivisor = this.defaultZoomDivisor = (double)defaultZoomDivisor;
            this.transition = transition == null ? new InstantTransitionMode() : transition;
            this.modifier = modifier;
            this.overlay = overlay;
        }

        @Override
        public ResourceLocation getInstanceId() {
            return this.instanceId;
        }

        @Override
        public boolean getZoom() {
            return this.zoom;
        }

        @Override
        public boolean setZoom(boolean newZoom) {
            this.zoom = newZoom;
            return this.zoom;
        }

        @Override
        public double getZoomDivisor() {
            return this.zoomDivisor;
        }

        @Override
        public double setZoomDivisor(double newDivisor) {
            this.zoomDivisor = newDivisor;
            return this.zoomDivisor;
        }

        @Override
        public double resetZoomDivisor() {
            this.zoomDivisor = this.defaultZoomDivisor;
            return this.zoomDivisor;
        }

        @Override
        public double getDefaultZoomDivisor() {
            return this.defaultZoomDivisor;
        }

        @Override
        public double setDefaultZoomDivisor(double newDivisor) {
            this.defaultZoomDivisor = newDivisor;
            return this.defaultZoomDivisor;
        }

        @Override
        public TransitionMode getTransitionMode() {
            return this.transition;
        }

        @Override
        public TransitionMode setTransitionMode(TransitionMode transition) {
            this.transition = transition;
            return this.transition;
        }

        @Override
        public boolean isTransitionActive() {
            return this.transition.getActive();
        }

        @Override
        @Nullable
        public MouseModifier getMouseModifier() {
            return this.modifier;
        }

        @Override
        public MouseModifier setMouseModifier(MouseModifier modifier) {
            this.modifier = modifier;
            return this.modifier;
        }

        @Override
        public boolean isModifierActive() {
            if (this.modifier != null) {
                return this.modifier.getActive();
            }
            return false;
        }

        @Override
        @Nullable
        public ZoomOverlay getZoomOverlay() {
            return this.overlay;
        }

        @Override
        public ZoomOverlay setZoomOverlay(ZoomOverlay overlay) {
            this.overlay = overlay;
            return this.overlay;
        }

        @Override
        public boolean isOverlayActive() {
            if (this.overlay != null) {
                return this.overlay.getActive();
            }
            return false;
        }
    }
}

