/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.utils;

import com.matyrobbrt.okzoomer.api.OkZoomerAPI;
import com.matyrobbrt.okzoomer.api.ZoomInstance;
import com.matyrobbrt.okzoomer.api.modifiers.ZoomDivisorMouseModifier;
import com.matyrobbrt.okzoomer.api.transitions.SmoothTransitionMode;
import com.matyrobbrt.okzoomer.config.ClientConfig;
import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final ZoomInstance ZOOMER_ZOOM = OkZoomerAPI.INSTANCE.registerZoom(OkZoomerAPI.INSTANCE.createZoomInstance(new ResourceLocation("ok_zoomer:zoom"), 4.0f, new SmoothTransitionMode(0.75f), new ZoomDivisorMouseModifier(), null));
    public static final TagKey<Item> ZOOM_DEPENDENCIES_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("okzoomer", "zoom_dependencies"));
    public static int zoomStep = 0;

    public static void changeZoomDivisor(boolean increase) {
        if (OkZoomerNetwork.getDisableZoom() || OkZoomerNetwork.getDisableZoomScrolling()) {
            return;
        }
        double zoomDivisor = (Double)ClientConfig.ZOOM_DIVISOR.get();
        double minimumZoomDivisor = (Double)ClientConfig.MINIMUM_ZOOM_DIVISOR.get();
        double maximumZoomDivisor = (Double)ClientConfig.MAXIMUM_ZOOM_DIVISOR.get();
        int upperScrollStep = (Integer)ClientConfig.UPPER_SCROLL_STEPS.get();
        int lowerScrollStep = (Integer)ClientConfig.LOWER_SCROLL_STEPS.get();
        if (OkZoomerNetwork.getForceZoomDivisors()) {
            double packetMinimumZoomDivisor = OkZoomerNetwork.getMinimumZoomDivisor();
            double packetMaximumZoomDivisor = OkZoomerNetwork.getMaximumZoomDivisor();
            if (packetMinimumZoomDivisor < minimumZoomDivisor) {
                minimumZoomDivisor = packetMinimumZoomDivisor;
            }
            if (packetMaximumZoomDivisor > maximumZoomDivisor) {
                maximumZoomDivisor = packetMaximumZoomDivisor;
            }
        }
        if ((zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep)) > 0) {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor + (maximumZoomDivisor - zoomDivisor) / (double)upperScrollStep * (double)zoomStep);
        } else if (zoomStep == 0) {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor);
        } else {
            ZOOMER_ZOOM.setZoomDivisor(zoomDivisor + (minimumZoomDivisor - zoomDivisor) / (double)lowerScrollStep * (double)(-zoomStep));
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (userPrompted && (OkZoomerNetwork.getDisableZoom() || OkZoomerNetwork.getDisableZoomScrolling())) {
            return;
        }
        ZOOMER_ZOOM.resetZoomDivisor();
        zoomStep = 0;
    }

    public static void keepZoomStepsWithinBounds() {
        int upperScrollStep = (Integer)ClientConfig.UPPER_SCROLL_STEPS.get();
        int lowerScrollStep = (Integer)ClientConfig.LOWER_SCROLL_STEPS.get();
        zoomStep = Mth.m_14045_((int)zoomStep, (int)(-lowerScrollStep), (int)upperScrollStep);
    }
}

