/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jeresources.collection.TradeList;
import jeresources.compatibility.CompatBase;
import jeresources.util.VillagersHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class VillagerEntry {
    private final List<TradeList> tradeList;
    private final VillagerProfession profession;
    @Nullable
    private Villager entity;

    public VillagerEntry(VillagerProfession profession, Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        this.profession = profession;
        this.tradeList = new LinkedList<TradeList>();
        this.addITradeLists(itemListings);
    }

    public void addITradeLists(Int2ObjectMap<VillagerTrades.ItemListing[]> itemListings) {
        for (int i = 1; i < itemListings.size() + 1; ++i) {
            VillagerTrades.ItemListing[] levelList = (VillagerTrades.ItemListing[])itemListings.get(i);
            TradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new TradeList(this);
            trades.addITradeList(levelList);
            this.tradeList.add(trades);
        }
    }

    public TradeList getVillagerTrades(int level) {
        if (this.tradeList.size() > level) {
            return this.tradeList.get(level);
        }
        return new TradeList(null);
    }

    public List<ItemStack> getInputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            for (TradeList.Trade trade : list2) {
                list.add(trade.getMinCostA());
                if (trade.getMinCostB().m_41619_()) continue;
                list.add(trade.getMinCostB());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(TradeList.Trade::getMinResult).collect(Collectors.toList()));
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public String getName() {
        return this.profession.toString();
    }

    public String getDisplayName() {
        return "entity.minecraft.villager." + this.profession.toString();
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public Villager getVillagerEntity() {
        if (this.entity == null) {
            this.entity = (Villager)EntityType.f_20492_.m_20615_(CompatBase.getLevel());
            assert (this.entity != null);
            this.entity.m_34375_(this.entity.m_7141_().m_35565_(this.profession));
        }
        return this.entity;
    }

    public List<ItemStack> getPois() {
        return VillagersHelper.getPoiBlocks(this.profession.f_219628_()).stream().map(blockstate -> new ItemStack((ItemLike)blockstate.m_60734_())).collect(Collectors.toList());
    }

    public boolean hasPois() {
        return !VillagersHelper.getPoiBlocks(this.profession.f_219628_()).isEmpty();
    }
}

