/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.Set;
import java.util.function.Predicate;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LogHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.block.state.BlockState;

public class VillagersHelper {
    public static void initRegistry(VillagerRegistry reg) {
        for (VillagerProfession profession : Registry.f_122869_) {
            try {
                reg.addVillagerEntry(new VillagerEntry(profession, VillagersHelper.getTrades(profession)));
            }
            catch (Exception e) {
                LogHelper.warn("Failed loading villager {} registered at {}", profession.toString(), profession.f_35600_());
                LogHelper.warn("Exception caught when registering villager", e);
            }
        }
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getTrades(VillagerProfession profession) {
        return VillagerTrades.f_35627_.getOrDefault(profession, Int2ObjectMaps.emptyMap());
    }

    public static Set<BlockState> getPoiBlocks(PoiType poiType) {
        return poiType.f_27325_();
    }

    public static Set<BlockState> getPoiBlocks(Predicate<Holder<PoiType>> heldJobSite) {
        return VillagersHelper.getPoiBlocks((PoiType)((Holder.Reference)Registry.f_122870_.m_203611_().filter(heldJobSite).findFirst().get()).m_203334_());
    }
}

