/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.mixins.client;

import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerSafetyLevel;
import com.aizistral.nochatreports.core.ServerSafetyState;
import com.aizistral.nochatreports.gui.EncryptionButton;
import com.aizistral.nochatreports.gui.EncryptionWarningScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen
extends Screen {
    private static final ResourceLocation CHAT_STATUS_ICONS = new ResourceLocation("nochatreports", "textures/gui/chat_status_icons_extended.png");
    private static final ResourceLocation ENCRYPTION_BUTTON = new ResourceLocation("nochatreports", "textures/gui/encryption_toggle_button.png");

    protected MixinChatScreen() {
        super(null);
        throw new IllegalStateException("Can't touch this");
    }

    @Inject(method={"normalizeChatMessage"}, at={@At(value="RETURN")}, cancellable=true)
    public void onBeforeMessage(String original, CallbackInfoReturnable<String> info) {
        String message = (String)info.getReturnValue();
        NCRConfig.getEncryption().setLastMessage(message);
        if (!message.isEmpty() && !Screen.m_96637_() && NCRConfig.getEncryption().shouldEncrypt(message)) {
            NCRConfig.getEncryption().getEncryptor().ifPresent(e -> {
                int index = NCRConfig.getEncryption().getEncryptionStartIndex(message);
                String noencrypt = message.substring(0, index);
                String encrypt = message.substring(index, message.length());
                if (encrypt.length() > 0) {
                    info.setReturnValue((Object)(noencrypt + e.encrypt("#%" + encrypt)));
                }
            });
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo info) {
        EncryptionButton button;
        int buttonX = this.f_96543_ - 23;
        if (NCRConfig.getClient().showServerSafety() && NCRConfig.getClient().enableMod()) {
            ServerSafetyLevel trust = this.f_96541_.m_91090_() ? ServerSafetyLevel.SECURE : ServerSafetyState.getCurrent();
            button = new ImageButton(buttonX, this.f_96544_ - 37, 20, 20, this.getXOffset(trust), 0, 20, CHAT_STATUS_ICONS, 128, 128, btn -> {}, (btn, poseStack, i, j) -> this.renderTooltipNoGap(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)trust.getTooltip(), 250), i, j), (Component)Component.m_237119_());
            button.f_93623_ = false;
            button.f_93624_ = true;
            this.m_169394_((Widget)button);
            buttonX -= 25;
        }
        if (!NCRConfig.getEncryption().showEncryptionButton()) {
            return;
        }
        int xStart = !NCRConfig.getEncryption().isValid() ? 40 : (NCRConfig.getEncryption().isEnabled() ? 0 : 20);
        button = new EncryptionButton(buttonX, this.f_96544_ - 37, 20, 20, xStart, 0, 20, ENCRYPTION_BUTTON, 64, 64, btn -> {
            if (!(EncryptionWarningScreen.seenOnThisSession() || NCRConfig.getEncryption().isWarningDisabled() || NCRConfig.getEncryption().isEnabled())) {
                Minecraft.m_91087_().m_91152_((Screen)new EncryptionWarningScreen(this));
            } else if (NCRConfig.getEncryption().isValid()) {
                NCRConfig.getEncryption().toggleEncryption();
                ((EncryptionButton)btn).f_94224_ = NCRConfig.getEncryption().isEnabledAndValid() ? 0 : 20;
            } else {
                ((EncryptionButton)btn).openEncryptionConfig();
            }
        }, (btn, poseStack, i, j) -> {
            if (NCRConfig.getEncryption().isValid()) {
                this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.nochatreports.encryption_tooltip", (Object[])new Object[]{Language.m_128107_().m_6834_("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off")), 250}), 250), i, j);
            } else {
                this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"gui.nochatreports.encryption_tooltip_invalid", (Object[])new Object[]{Language.m_128107_().m_6834_("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off")), 250}), 250), i, j);
            }
        }, (Component)Component.m_237119_(), this);
        button.f_93623_ = true;
        button.f_93624_ = true;
        this.m_142416_((GuiEventListener)button);
    }

    private int getXOffset(ServerSafetyLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ServerSafetyLevel.SECURE -> 21;
            case ServerSafetyLevel.UNINTRUSIVE -> 42;
            case ServerSafetyLevel.INSECURE -> 0;
            case ServerSafetyLevel.REALMS -> 63;
            case ServerSafetyLevel.UNKNOWN -> 84;
            case ServerSafetyLevel.UNDEFINED -> 105;
        };
    }

    protected void renderTooltipNoGap(PoseStack poseStack, List<? extends FormattedCharSequence> list, int i, int j) {
        this.renderTooltipInternalNoGap(poseStack, list.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), i, j);
    }

    protected void renderTooltipInternalNoGap(PoseStack poseStack, List<ClientTooltipComponent> list, int i, int j) {
        ClientTooltipComponent clientTooltipComponent2;
        int v;
        int m;
        if (list.isEmpty()) {
            return;
        }
        int k = 0;
        int l = list.size() == 1 ? -2 : -2;
        for (ClientTooltipComponent clientTooltipComponent : list) {
            m = clientTooltipComponent.m_142069_(this.f_96547_);
            if (m > k) {
                k = m;
            }
            l += clientTooltipComponent.m_142103_();
        }
        int n = i + 12;
        int o = j - 12;
        m = k;
        int p = l;
        if (n + k > this.f_96543_) {
            n -= 28 + k;
        }
        if (o + p + 6 > this.f_96544_) {
            o = this.f_96544_ - p - 6;
        }
        if (j - p - 8 < 0) {
            o = j + 8;
        }
        poseStack.m_85836_();
        int q = -267386864;
        int r = 0x505000FF;
        int s = 1344798847;
        int t = 400;
        float f = this.f_96542_.f_115093_;
        this.f_96542_.f_115093_ = 400.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o - 4), (int)(n + m + 3), (int)(o - 3), (int)400, (int)-267386864, (int)-267386864);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o + p + 3), (int)(n + m + 3), (int)(o + p + 4), (int)400, (int)-267386864, (int)-267386864);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o - 3), (int)(n + m + 3), (int)(o + p + 3), (int)400, (int)-267386864, (int)-267386864);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 4), (int)(o - 3), (int)(n - 3), (int)(o + p + 3), (int)400, (int)-267386864, (int)-267386864);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n + m + 3), (int)(o - 3), (int)(n + m + 4), (int)(o + p + 3), (int)400, (int)-267386864, (int)-267386864);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o - 3 + 1), (int)(n - 3 + 1), (int)(o + p + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n + m + 2), (int)(o - 3 + 1), (int)(n + m + 3), (int)(o + p + 3 - 1), (int)400, (int)0x505000FF, (int)1344798847);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o - 3), (int)(n + m + 3), (int)(o - 3 + 1), (int)400, (int)0x505000FF, (int)0x505000FF);
        Screen.m_93123_((Matrix4f)matrix4f, (BufferBuilder)bufferBuilder, (int)(n - 3), (int)(o + p + 2), (int)(n + m + 3), (int)(o + p + 3), (int)400, (int)1344798847, (int)1344798847);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int u = o;
        for (v = 0; v < list.size(); ++v) {
            clientTooltipComponent2 = list.get(v);
            clientTooltipComponent2.m_142440_(this.f_96547_, n, u, matrix4f, bufferSource);
            u += clientTooltipComponent2.m_142103_();
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        u = o;
        for (v = 0; v < list.size(); ++v) {
            clientTooltipComponent2 = list.get(v);
            clientTooltipComponent2.m_183452_(this.f_96547_, n, u, poseStack, this.f_96542_, 400);
            u += clientTooltipComponent2.m_142103_() + (v == 0 ? 2 : 0);
        }
        this.f_96542_.f_115093_ = f;
    }
}

