/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.ReflectionUtils;
import virtuoel.no_fog.util.VersionUtils;

public class ConfigUtils {
    private static Object dimensionTypeRegistryWrapper = null;
    private static Object biomeRegistryWrapper = null;

    public static Map<String, FogToggles> populateDimensionToggles(Map<String, FogToggles> data) {
        LinkedList<String> ids = new LinkedList<String>();
        try {
            Minecraft client = Minecraft.m_91087_();
            if (client != null && client.f_91073_ != null) {
                Registry<DimensionType> registry = ReflectionUtils.getDynamicRegistry((CommonLevelAccessor)client.f_91073_, ReflectionUtils.DIMENSION_TYPE_KEY);
                ReflectionUtils.getIds(registry).stream().map(ResourceLocation::toString).sorted().forEach(ids::add);
            }
        }
        catch (Throwable e) {
            NoFogClient.LOGGER.catching(e);
        }
        if (ids.isEmpty()) {
            try {
                if (VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 2) {
                    ids.add(Level.f_46428_.m_135782_().toString());
                    ids.add(Level.f_46429_.m_135782_().toString());
                    ids.add(Level.f_46430_.m_135782_().toString());
                }
            }
            catch (Throwable e) {
                NoFogClient.LOGGER.catching(e);
            }
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
        }
        return data;
    }

    public static Map<String, FogToggles> populateBiomeToggles(Map<String, FogToggles> data) {
        LinkedList ids = new LinkedList();
        try {
            Minecraft client = Minecraft.m_91087_();
            if (client != null && client.f_91073_ != null) {
                Registry<Biome> registry = ReflectionUtils.getDynamicRegistry((CommonLevelAccessor)client.f_91073_, ReflectionUtils.BIOME_KEY);
                ids.addAll(ReflectionUtils.getIds(registry).stream().map(ResourceLocation::toString).sorted().collect(Collectors.toList()));
            }
        }
        catch (Throwable e) {
            NoFogClient.LOGGER.catching(e);
        }
        if (ids.isEmpty()) {
            try {
                if (ReflectionUtils.BUILTIN_BIOME_REGISTRY != null) {
                    ReflectionUtils.getIds(ReflectionUtils.BUILTIN_BIOME_REGISTRY).stream().map(ResourceLocation::toString).sorted().forEach(ids::add);
                }
            }
            catch (Throwable e) {
                NoFogClient.LOGGER.catching(e);
            }
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
        }
        return data;
    }
}

