/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.VersionUtils;

public class ReflectionUtils {
    public static final MethodHandle FOG_DENSITY;
    public static final MethodHandle FOG_START;
    public static final MethodHandle FOG_END;
    public static final ResourceKey<Registry<Fluid>> FLUID_KEY;
    public static final ResourceKey<Registry<Biome>> BIOME_KEY;
    public static final ResourceKey<Registry<DimensionType>> DIMENSION_TYPE_KEY;
    public static final Registry<Biome> BUILTIN_BIOME_REGISTRY;
    public static final ReflectionUtils INSTANCE;

    public static <E> Registry<E> getDynamicRegistry(CommonLevelAccessor w, ResourceKey<? extends Registry<E>> key) {
        return w.m_5962_().m_175515_(key);
    }

    public static String getBiomeId(Entity entity) {
        Biome biome = (Biome)entity.f_19853_.m_204166_(new BlockPos(entity.m_20182_())).m_203334_();
        return ReflectionUtils.getId(ReflectionUtils.getDynamicRegistry((CommonLevelAccessor)entity.f_19853_, BIOME_KEY), biome).toString();
    }

    public static Set<ResourceLocation> getIds(Registry<?> registry) {
        return registry.m_6566_();
    }

    public static <V> ResourceLocation getId(Registry<V> registry, V entry) {
        return registry.m_7981_(entry);
    }

    public static void setFogDensity(float f) throws Throwable {
        if (FOG_DENSITY != null) {
            FOG_DENSITY.invokeExact(f);
        }
    }

    public static void setFogStart(float f) throws Throwable {
        if (FOG_START != null) {
            FOG_START.invokeExact(f);
        }
    }

    public static void setFogEnd(float f) throws Throwable {
        if (FOG_END != null) {
            FOG_END.invokeExact(f);
        }
    }

    public static <T> T getFieldValue(Field field, Object object, Supplier<T> defaultValue) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return defaultValue.get();
        }
    }

    private ReflectionUtils() {
    }

    static {
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        try {
            boolean is116;
            boolean bl = is116 = VersionUtils.MINOR == 16;
            if (is116) {
                Class<?> clazz = Class.forName("com.mojang.blaze3d.systems.RenderSystem");
                Method m = clazz.getMethod("fogDensity", Float.TYPE);
                h.put(0, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogStart", Float.TYPE);
                h.put(1, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogEnd", Float.TYPE);
                h.put(2, (Object)lookup.unreflect(m));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException e1) {
            NoFogClient.LOGGER.error("Current name lookup: {}", (Object)mapped);
            NoFogClient.LOGGER.catching((Throwable)e1);
        }
        FOG_DENSITY = (MethodHandle)h.get(0);
        FOG_START = (MethodHandle)h.get(1);
        FOG_END = (MethodHandle)h.get(2);
        FLUID_KEY = Registry.f_122899_;
        BIOME_KEY = Registry.f_122885_;
        DIMENSION_TYPE_KEY = Registry.f_122818_;
        BUILTIN_BIOME_REGISTRY = BuiltinRegistries.f_123865_;
        INSTANCE = new ReflectionUtils();
    }
}

