/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.client.resource;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.mojang.bridge.game.GameVersion;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class ExperimentalResourcePack
implements PackResources {
    private static final String PACK_DESC = "Experimental Resource Pack for Enhanced Block Entities";
    public final String f_143749_ = String.format("{\"pack\":{\"pack_format\":%s,\"description\":\"%s\"}}", PackType.CLIENT_RESOURCES.m_143756_((GameVersion)SharedConstants.m_183709_()), "Experimental Resource Pack for Enhanced Block Entities");
    private final Map<ResourceLocation, byte[]> resources = new Object2ObjectOpenHashMap();
    private final Set<String> namespaces = new HashSet<String>();

    public void put(ResourceLocation id, byte[] resource) {
        this.resources.put(id, resource);
        this.namespaces.add(id.m_135827_());
    }

    public InputStream m_5542_(String fileName) throws IOException {
        if ("pack.mcmeta".equals(fileName)) {
            return IOUtils.toInputStream((String)this.f_143749_, (Charset)Charsets.UTF_8);
        }
        throw new FileNotFoundException("No such file '" + fileName + "' in EBE experimental resources");
    }

    public InputStream m_8031_(PackType type, ResourceLocation id) throws IOException {
        if (type == PackType.CLIENT_RESOURCES && this.resources.containsKey(id)) {
            return new ByteArrayInputStream(this.resources.get(id));
        }
        throw new FileNotFoundException("No such resource '" + id.toString() + "' of type '" + type.toString() + "' in EBE experimental resources");
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String prefix, Predicate<ResourceLocation> pathFilter) {
        if (type == PackType.CLIENT_RESOURCES) {
            ImmutableList.Builder r = ImmutableList.builder();
            this.resources.keySet().forEach(id -> {
                if (id.m_135827_().equals(namespace) && id.m_135815_().startsWith(prefix) && pathFilter.test(ResourceLocation.m_135820_((String)id.m_135815_()))) {
                    r.add(id);
                }
            });
        }
        return Collections.emptyList();
    }

    public boolean m_7211_(PackType type, ResourceLocation id) {
        if (type == PackType.CLIENT_RESOURCES) {
            return this.resources.containsKey(id);
        }
        return false;
    }

    public Set<String> m_5698_(PackType type) {
        return this.namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        return (T)AbstractPackResources.m_10214_(metaReader, (InputStream)this.m_5542_("pack.mcmeta"));
    }

    public String m_8017_() {
        return "ebe:exp_resources";
    }

    public void close() {
    }
}

