/*
 * Decompiled with CFR 0.152.
 */
package foundationgames.enhancedblockentities.mixin;

import foundationgames.enhancedblockentities.client.model.DynamicModelProvider;
import foundationgames.enhancedblockentities.util.resource_provider.ResourceProviderHolder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Final
    @Shadow
    public static ModelResourceLocation f_119230_;
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119212_;
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119214_;

    @Shadow
    private void m_119352_(ResourceLocation id, UnbakedModel unbakedModel) {
    }

    @Shadow
    public abstract UnbakedModel m_119341_(ResourceLocation var1);

    @Inject(at={@At(value="HEAD")}, method={"loadModel"}, cancellable=true)
    private void loadModelHook(ResourceLocation id, CallbackInfo ci) {
        UnbakedModel customModel = this.loadModelFromVariant(id);
        if (customModel != null) {
            this.m_119352_(id, customModel);
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"loadTopLevel"})
    private void addModelHook(ModelResourceLocation id, CallbackInfo info) {
        if (id == f_119230_) {
            for (Consumer<Consumer<ResourceLocation>> appender : ResourceProviderHolder.INSTANCE.appenders) {
                appender.accept(this::addModel);
            }
        }
    }

    public void addModel(ResourceLocation id) {
        if (id instanceof ModelResourceLocation) {
            this.addModel((ResourceLocation)((ModelResourceLocation)id));
        } else {
            UnbakedModel unbakedModel = this.m_119341_(id);
            this.f_119212_.put(id, unbakedModel);
            this.f_119214_.put(id, unbakedModel);
        }
    }

    @Nullable
    public UnbakedModel loadModelFromResource(ResourceLocation resourceId) {
        return this.loadCustomModel(r -> ((DynamicModelProvider)r.get()).loadModelResource(resourceId), ResourceProviderHolder.INSTANCE.resourceProviders, "resource provider");
    }

    private <T> UnbakedModel loadCustomModel(Function<T, UnbakedModel> function, Collection<T> loaders, String debugName) {
        for (T provider : loaders) {
            UnbakedModel model = function.apply(provider);
            if (model == null) continue;
            return model;
        }
        return null;
    }

    @Nullable
    public UnbakedModel loadModelFromVariant(ResourceLocation variantId) {
        ResourceLocation resourceId;
        if (!(variantId instanceof ModelResourceLocation)) {
            return this.loadModelFromResource(variantId);
        }
        ModelResourceLocation modelId = (ModelResourceLocation)variantId;
        UnbakedModel model = null;
        if (Objects.equals(modelId.m_119448_(), "inventory") && (model = this.loadModelFromResource(resourceId = new ResourceLocation(modelId.m_135827_(), "item/" + modelId.m_135815_()))) != null) {
            return model;
        }
        return null;
    }
}

